/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;

public final class PropertyMap
extends TreeMap<String, String> {
    private static final long serialVersionUID = 1L;

    public void read(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        Reader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "ISO-8859-1"));
            int state = 1;
            StringBuilder key = null;
            StringBuilder value = null;
            int ch = in.read();
            int prev = -1;
            while (ch != -1) {
                if (ch == 10 || ch == 13) {
                    if (state == 3) {
                        this.put(PropertyMap.unescape(key.toString().trim()), PropertyMap.unescape(value.toString().trim()));
                        state = 1;
                    } else if (state == 4) {
                        state = 1;
                    } else if (state == 2) {
                        throw new IOException("Malformed property file.");
                    }
                } else if (ch == 61 && prev != 92 && state == 2) {
                    value = new StringBuilder();
                    state = 3;
                } else if (ch == 35 && state == 1) {
                    state = 4;
                } else if (state == 1) {
                    key = new StringBuilder();
                    key.append((char)ch);
                    state = 2;
                } else if (state == 2) {
                    key.append((char)ch);
                } else if (state == 3) {
                    value.append((char)ch);
                }
                prev = ch;
                ch = in.read();
            }
            if (state == 3) {
                this.put(PropertyMap.unescape(key.toString().trim()), PropertyMap.unescape(value.toString().trim()));
            } else if (state == 2) {
                throw new IOException("Malformed property file.");
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void write(File f) throws IOException {
        String linesep = System.getProperty("line.separator");
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "ISO-8859-1"));
            for (Map.Entry entry : this.entrySet()) {
                out.write(PropertyMap.escape(((String)entry.getKey()).toString()));
                out.write(" = ");
                out.write(PropertyMap.escape(((String)entry.getValue()).toString()));
                out.write(linesep);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String escape(String str) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = str.length();
        while (i < n) {
            char ch = str.charAt(i);
            if (ch == ':') {
                buf.append("\\:");
            } else if (ch == ' ') {
                buf.append("\\ ");
            } else if (ch == '\\') {
                buf.append("\\\\");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String unescape(String str) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = str.length();
        while (i < n) {
            int ch = str.charAt(i);
            if (ch == 92 && i + 1 < n) {
                if ((ch = str.charAt(++i)) == 114) {
                    ch = 13;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 116) {
                    ch = 9;
                }
            }
            buf.append((char)ch);
            ++i;
        }
        return buf.toString();
    }
}

