/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import oracle.eclipse.tools.common.util.MutableReference;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;

public final class EclipseThreadingUtil {
    private EclipseThreadingUtil() {
    }

    public static void waitForActivityToCease(int timeout) {
        EclipseThreadingUtil.waitForResourceChangesToCease(timeout);
        EclipseThreadingUtil.waitForJobsActivityToCease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void waitForResourceChangesToCease(final int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        final MutableReference<Integer> counter = new MutableReference<Integer>();
        counter.set(timeout);
        IResourceChangeListener listener = new IResourceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resourceChanged(IResourceChangeEvent event) {
                MutableReference mutableReference = counter;
                synchronized (mutableReference) {
                    counter.set(timeout);
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addResourceChangeListener(listener, 1);
        try {
            while (true) {
                MutableReference<Integer> mutableReference = counter;
                synchronized (mutableReference) {
                    if ((Integer)counter.get() == 0) {
                        break;
                    }
                }
                try {
                    Thread.sleep(1000L);
                    mutableReference = counter;
                    synchronized (mutableReference) {
                        counter.set((Integer)counter.get() - 1);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        finally {
            ws = ResourcesPlugin.getWorkspace();
            if (ws != null) {
                ws.removeResourceChangeListener(listener);
            }
        }
    }

    public static final void waitForJobsActivityToCease() {
        while (!Job.getJobManager().isIdle()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

