/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.eclipse.tools.common.internal.OracleCommonToolsPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class EclipseDomUtil {
    public static Document doc(IFile f) throws CoreException {
        Document document;
        InputStream in = f.getContents();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8);
            document = EclipseDomUtil.doc(reader);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return document;
    }

    public static Document doc(Reader r) throws CoreException {
        DocumentBuilder docbuilder = EclipseDomUtil.docbuilder();
        try {
            return docbuilder.parse(new InputSource(r));
        }
        catch (IOException e) {
            throw EclipseDomUtil.convert(e);
        }
        catch (SAXParseException e) {
            throw EclipseDomUtil.convert(e);
        }
        catch (SAXException e) {
            throw EclipseDomUtil.convert(e);
        }
    }

    public static Element root(IFile f) throws CoreException {
        return EclipseDomUtil.doc(f).getDocumentElement();
    }

    public static Element root(Reader r) throws CoreException {
        return EclipseDomUtil.doc(r).getDocumentElement();
    }

    public static DocumentBuilder docbuilder() throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw EclipseDomUtil.convert(e);
        }
    }

    private static CoreException convert(Throwable e) {
        IStatus status = OracleCommonToolsPlugin.createErrorStatus(String.valueOf(e.getMessage()), e);
        return new CoreException(status);
    }
}

