/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.eclipse.tools.common.util.XmlParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DomUtil {
    public static Document doc(Reader r) {
        DocumentBuilder docbuilder = DomUtil.docbuilder();
        try {
            return docbuilder.parse(new InputSource(r));
        }
        catch (IOException e) {
            throw new XmlParseException(e);
        }
        catch (SAXParseException e) {
            throw new XmlParseException(e);
        }
        catch (SAXException e) {
            throw new XmlParseException(e);
        }
    }

    public static Document doc(InputStream stream) {
        DocumentBuilder docbuilder = DomUtil.docbuilder();
        try {
            return docbuilder.parse(stream);
        }
        catch (IOException e) {
            throw new XmlParseException(e);
        }
        catch (SAXParseException e) {
            throw new XmlParseException(e);
        }
        catch (SAXException e) {
            throw new XmlParseException(e);
        }
    }

    public static Document doc(String str) {
        return DomUtil.doc(new StringReader(str));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document doc(File f) {
        Document document;
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(f));
            document = DomUtil.doc(stream);
            if (stream == null) return document;
        }
        catch (IOException e) {
            try {
                throw new XmlParseException(e);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return document;
        }
        catch (IOException iOException) {}
        return document;
    }

    public static Document doc() {
        return DomUtil.docbuilder().newDocument();
    }

    public static Element root(Reader r) {
        return DomUtil.doc(r).getDocumentElement();
    }

    public static Element root(String str) {
        return DomUtil.doc(str).getDocumentElement();
    }

    public static Element root(File f) {
        return DomUtil.doc(f).getDocumentElement();
    }

    public static Element element(Element el, String name) {
        NodeList nodes = el.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && DomUtil.basename(node.getNodeName()).equals(name)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public static Iterable<Element> elements(Element el) {
        return new ElementsIterator(el.getChildNodes());
    }

    public static Iterable<Element> elements(Element el, String name) {
        return new ElementsIterator(el.getChildNodes(), name);
    }

    public static Iterable<Element> elements(NodeList nodes) {
        return new ElementsIterator(nodes);
    }

    public static Iterable<Element> elements(NodeList nodes, String name) {
        return new ElementsIterator(nodes, name);
    }

    public static String text(Node node) {
        NodeList nodes = node.getChildNodes();
        String str = null;
        StringBuilder buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node childNode = nodes.item(i);
            short childNodeType = childNode.getNodeType();
            if (childNodeType == 3 || childNodeType == 4) {
                String val = childNode.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuilder();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str;
    }

    public static String text(Element el, String childElementName) {
        Element childElement = DomUtil.element(el, childElementName);
        if (childElement == null) {
            return null;
        }
        return DomUtil.text(childElement);
    }

    public static String basename(String name) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            return name.substring(colon + 1);
        }
        return name;
    }

    public static void swap(Node x, Node y) {
        Node parent = x.getParentNode();
        Document document = parent.getOwnerDocument();
        Text xBookmark = document.createTextNode("");
        parent.insertBefore(xBookmark, x);
        Text yBookmark = document.createTextNode("");
        parent.insertBefore(yBookmark, y);
        parent.removeChild(x);
        parent.removeChild(y);
        parent.insertBefore(x, yBookmark);
        parent.insertBefore(y, xBookmark);
        parent.removeChild(xBookmark);
        parent.removeChild(yBookmark);
    }

    public static void write(Document doc, File file) {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static DocumentBuilder docbuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class ElementsIterator
    implements Iterator<Element>,
    Iterable<Element> {
        private final NodeList nodes;
        private final int length;
        private final String name;
        private int position;
        private Element element;

        public ElementsIterator(NodeList nodes) {
            this(nodes, null);
        }

        public ElementsIterator(NodeList nodes, String name) {
            this.nodes = nodes;
            this.length = nodes.getLength();
            this.position = -1;
            this.name = name;
            this.advance();
        }

        private void advance() {
            this.element = null;
            ++this.position;
            while (this.position < this.length && this.element == null) {
                Node node = this.nodes.item(this.position);
                if (node.getNodeType() == 1 && (this.name == null || DomUtil.basename(node.getNodeName()).equals(this.name))) {
                    this.element = (Element)node;
                }
                ++this.position;
            }
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public Element next() {
            Element el = this.element;
            if (el == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return el;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Element> iterator() {
            return this;
        }
    }
}

