/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CollectionsUtil {
    private static final Comparator<Comparable<? super Comparable>> INVERTING_COMPARATOR = new Comparator<Comparable<? super Comparable>>(){

        @Override
        public int compare(Comparable<? super Comparable> obj1, Comparable<? super Comparable> obj2) {
            return obj2.compareTo(obj1);
        }
    };

    private CollectionsUtil() {
    }

    public static <T extends Comparable> Comparator<T> getInvertingComparator() {
        return INVERTING_COMPARATOR;
    }

    public static <T> Set<T> set(T ... entries) {
        switch (entries.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(entries[0]);
            }
        }
        HashSet<T> result = new HashSet<T>();
        T[] TArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            T entry = TArray[n2];
            result.add(entry);
            ++n2;
        }
        return result;
    }

    public static <T> List<T> list(T ... entries) {
        switch (entries.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(entries[0]);
            }
        }
        ArrayList<T> result = new ArrayList<T>();
        T[] TArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            T entry = TArray[n2];
            result.add(entry);
            ++n2;
        }
        return result;
    }
}

