/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.otn;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

public class SSOUtil {
    private static final String OTN_LOGIN_HANDLER = "https://login.oracle.com/oam/server/sso/auth_cred_submit";
    private static final String USER_AGENT = "Mozilla/4.0 (compatible; Windows NT 5.1) OracleEMAgentURLTiming/3.0";
    private static final String GET = "GET";
    private static final String POST = "POST";
    static boolean debug = true;
    private static String SITE2PSTORETOKEN = "site2pstoretoken";

    /*
     * Unable to fully structure code
     */
    private static SiteToken getSiteToken(String fileUrl, Proxy proxy) throws IOException {
        ret = null;
        HttpURLConnection.setDefaultAllowUserInteraction(false);
        site2pstoretoken = null;
        urlConnection = SSOUtil.newConnection(fileUrl, proxy, "GET");
        wr = new DataOutputStream(urlConnection.getOutputStream());
        wr.flush();
        wr.close();
        code = urlConnection.getResponseCode();
        headerName = null;
        if (code != 200) ** GOTO lbl41
        token = new SiteToken();
        token.urlConnection = urlConnection;
        return token;
lbl-1000:
        // 1 sources

        {
            location = null;
            SSOUtil.trace("================================= site2pstoretoken =============================");
            i = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
                SSOUtil.trace(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
                if (headerName.equals("Location") && (location = urlConnection.getHeaderField(i)).indexOf("login.oracle.com") > 0) {
                    key = String.valueOf(SSOUtil.SITE2PSTORETOKEN) + "=";
                    beginIndex = location.toLowerCase().indexOf(key);
                    if (beginIndex > 0) {
                        val = location.substring(beginIndex + key.length());
                        n = val.indexOf("&");
                        if (n > 0) {
                            val = val.substring(0, n);
                        }
                        site2pstoretoken = val;
                        ret = new SiteToken();
                        ret.site2pstoretoken = site2pstoretoken;
                    }
                }
                if (headerName.equals("Set-Cookie") && (cookie = urlConnection.getHeaderField(i)).startsWith("OAM_REQ")) {
                    n1 = "OAM_REQ".length() + 1;
                    n2 = cookie.indexOf(59);
                    ret.OAM_REQ = cookie.substring(n1, n2 > 0 ? n2 : cookie.length());
                }
                ++i;
            }
            if (ret != null && ret.isComplete()) {
                return ret;
            }
            if (location == null) continue;
            urlConnection = SSOUtil.newConnection(location, proxy, "GET");
            code = urlConnection.getResponseCode();
lbl41:
            // 3 sources

            ** while (code > 300 && code < 400)
        }
lbl42:
        // 1 sources

        if (code == 200) {
            SSOUtil.trace("================================= OAM_REQ =============================");
            i = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
                SSOUtil.trace(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
                if (headerName.equals("Set-Cookie") && (cookie = urlConnection.getHeaderField(i)).startsWith("OAM_REQ")) {
                    n1 = "OAM_REQ".length() + 1;
                    n2 = cookie.indexOf(59);
                    ret.OAM_REQ = cookie.substring(n1, n2 > 0 ? n2 : cookie.length());
                }
                ++i;
            }
            if (ret.OAM_REQ == null && (n = (html = SSOUtil.readResponse(urlConnection)).indexOf(token = "name=\"OAM_REQ\" value=\"")) > 0) {
                text = html.substring(n + token.length());
                ret.OAM_REQ = text = text.substring(0, text.indexOf(34));
            }
        }
        return ret;
    }

    private static void trace(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static HttpURLConnection getConnection(String fileUrl, Proxy proxy, String userName, String password) throws IOException {
        String location;
        boolean foundDownloadUrl = false;
        SiteToken token = SSOUtil.getSiteToken(fileUrl, proxy);
        if (token == null || token.OAM_REQ == null) {
            String msg = "Error retrieve OAM_REQ or Site2pstoretoken  to Oracel Access Manager " + fileUrl;
            throw new IOException(msg);
        }
        if (token.urlConnection != null) {
            return token.urlConnection;
        }
        HttpURLConnection urlConnection = SSOUtil.newConnection(OTN_LOGIN_HANDLER, proxy, POST);
        String urlParameters = "";
        urlParameters = String.valueOf(urlParameters) + "&ssousername=";
        urlParameters = String.valueOf(urlParameters) + userName;
        urlParameters = String.valueOf(urlParameters) + "&password=";
        urlParameters = String.valueOf(urlParameters) + password;
        urlParameters = String.valueOf(urlParameters) + "&v=v1.4";
        urlParameters = String.valueOf(urlParameters) + "&p_submit_url=/sso/auth";
        urlParameters = String.valueOf(urlParameters) + "&site2pstoretoken=" + token.site2pstoretoken;
        urlParameters = String.valueOf(urlParameters) + "&OAM_REQ=" + token.OAM_REQ;
        urlConnection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes(StandardCharsets.UTF_8).length));
        urlConnection.setRequestProperty("Content-Language", "en-US");
        DataOutputStream wr = new DataOutputStream(urlConnection.getOutputStream());
        wr.writeBytes(urlParameters);
        wr.flush();
        wr.close();
        int code = urlConnection.getResponseCode();
        String headerName = null;
        if (code == 401) {
            throw new IOException("Unauthorized request. Please check your username and password");
        }
        if (code == 200) {
            int i = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
                if (debug) {
                    System.out.println(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
                }
                ++i;
            }
            if (debug) {
                String html = SSOUtil.readResponse(urlConnection);
                System.err.println(html);
            }
            throw new IOException("Unauthorized request. Please check your username and password");
        }
        String cookie = "";
        SSOUtil.trace("================================= Header =============================");
        int i = 1;
        while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
            if (debug) {
                System.out.println(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
            }
            if (headerName.equals("Set-Cookie")) {
                cookie = String.valueOf(cookie) + urlConnection.getHeaderField(i) + "; ";
            } else if (headerName.equals("Location")) {
                location = urlConnection.getHeaderField(i);
                if (location.indexOf("login.oracle.com") > 0) {
                    if (debug) {
                        System.out.println("Unauthorized request. Please check your username and password");
                    }
                    return null;
                }
                String msg = SSOUtil.readResponse(urlConnection);
                if (debug) {
                    System.out.println(msg);
                }
            }
            ++i;
        }
        if (code == 200) {
            if (debug) {
                String html = SSOUtil.readResponse(urlConnection);
                System.out.println(html);
            }
            return urlConnection;
        }
        boolean setCookie = true;
        while (code > 300 && code < 400) {
            location = urlConnection.getHeaderField("Location");
            System.err.println(location);
            if (location != null) {
                foundDownloadUrl = true;
            }
            urlConnection = SSOUtil.newConnection(location, proxy, GET);
            if (setCookie) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            code = urlConnection.getResponseCode();
            cookie = "";
            int i2 = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i2)) != null) {
                SSOUtil.trace(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i2));
                if (headerName.equals("Set-Cookie")) {
                    cookie = String.valueOf(cookie) + urlConnection.getHeaderField(i2) + "; ";
                }
                ++i2;
            }
        }
        if (foundDownloadUrl) {
            return urlConnection;
        }
        return null;
    }

    private static HttpURLConnection newConnection(String location, Proxy proxy, String method) throws IOException {
        HttpURLConnection urlConnection = null;
        URL newUrl = new URL(location);
        urlConnection = proxy != null ? (HttpURLConnection)newUrl.openConnection(proxy) : (HttpURLConnection)newUrl.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setRequestProperty("User-Agent", USER_AGENT);
        urlConnection.setRequestProperty("Accept-Encoding", "gzip, deflate, sdch");
        urlConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        urlConnection.setInstanceFollowRedirects(false);
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setUseCaches(false);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        return urlConnection;
    }

    public static void writeFile(URLConnection urlConnection, File destFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = urlConnection.getInputStream();
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[262144];
            int count = 0;
            int bytesTransfered = 0;
            int n = 1;
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
                if ((bytesTransfered += count) <= n * 1024 * 1024) continue;
                System.out.print(".");
                System.out.flush();
                if (++n % 80 != 0) continue;
                System.out.println();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String readResponse(URLConnection urlConnection) throws IOException {
        InputStream in = null;
        StringBuilder ret = new StringBuilder();
        try {
            in = urlConnection.getInputStream();
            byte[] buffer = new byte[16384];
            int count = 0;
            while ((count = in.read(buffer)) != -1) {
                String msg = new String(buffer, 0, count, "UTF-8");
                ret.append(msg);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("SSOUtil [url] [userName] [passwd] [destination directory] [-verbose]");
        } else {
            String url = args[0];
            String userName = args[1];
            String password = args[2];
            File destDir = new File(args[3]);
            if (args.length > 4 && "-verbose".equals(args[4])) {
                debug = true;
            }
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            Proxy proxy = null;
            if (proxyHost != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
            }
            System.err.println(url);
            HttpURLConnection urlConnection = SSOUtil.getConnection(url, proxy, userName, password);
            if (urlConnection != null) {
                int size = urlConnection.getContentLength();
                System.out.println("Downloading from : " + urlConnection.getURL().toString());
                System.out.println("Total size = " + size / 0x100000 + "MB");
                String fileName = url.substring(url.lastIndexOf(47) + 1);
                SSOUtil.writeFile(urlConnection, new File(destDir, fileName));
            }
        }
    }

    static class SiteToken {
        String OAM_REQ = null;
        String site2pstoretoken = null;
        HttpURLConnection urlConnection;

        SiteToken() {
        }

        public boolean isComplete() {
            return this.OAM_REQ != null && this.site2pstoretoken != null;
        }
    }
}

