/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.otn;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;

public class OTNDownloadUtil {
    public static final String ADF_DOWNLOAD_URL = "http://www.oracle.com/technetwork/developer-tools/adf/downloads/index.html";
    private static final String OTN_LOGIN_HANDLER = "https://login.oracle.com/oam/server/sso/auth_cred_submit";
    private static final String SSO_REDIRECT_URL = "http://www.oracle.com/webapps/redirect/signon?nexturl=http://www.oracle.com/technetwork/developer-tools/adf/downloads/index.html";
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 5.1; rv:14.0) Gecko/20100101 Firefox/14.0";
    private static final String GET = "GET";
    private static final String POST = "POST";
    static boolean debug = false;
    private static String SITE2PSTORETOKEN = "site2pstoretoken";

    /*
     * Unable to fully structure code
     */
    private static SiteToken getSiteToken(Proxy proxy) throws IOException {
        ret = null;
        HttpURLConnection.setDefaultAllowUserInteraction(false);
        site2pstoretoken = null;
        urlConnection = OTNDownloadUtil.newConnection("http://www.oracle.com/webapps/redirect/signon?nexturl=http://www.oracle.com/technetwork/developer-tools/adf/downloads/index.html", proxy, "GET");
        cookies = new TreeSet<String>();
        cookies.add(" gpw_e24=http%3A%2F%2Fwww.oracle.com%2Ftechnetwork%2Fdeveloper-tools%2Fadf%2Fdownloads%2Findex.html;");
        cookies.add(" s_cc=true;");
        cookies.add(" testSessionCookie=Enabled;");
        cookies.add(" oraclelicense=accept-dbindex-cookie;");
        cookies.add(" s_sq=oracleotnlive%2Coracleglobal%3D%2526pid%253Dotn%25253Aen-us%25253A%25252Fdeveloper-tools%25252Fadf%25252Fdownloads%25252F%2526pidt%253D1%2526oid%253Dfunctiononclick(event)%25257BacceptAgreement(window.self)%25253B%25257D%2526oidt%253D2%2526ot%253DRADIO;");
        cookies.add(" ARU_LANG=US;");
        urlConnection.addRequestProperty("Cookie", OTNDownloadUtil.toString(cookies));
        urlConnection.connect();
        code = urlConnection.getResponseCode();
        headerName = null;
        if (code != 200) ** GOTO lbl56
        token = new SiteToken();
        return token;
lbl-1000:
        // 1 sources

        {
            location = null;
            OTNDownloadUtil.trace("================================= site2pstoretoken =============================");
            i = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
                OTNDownloadUtil.trace(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
                if (headerName.equals("Location") && (location = urlConnection.getHeaderField(i)).indexOf("login.oracle.com") > 0) {
                    key = String.valueOf(OTNDownloadUtil.SITE2PSTORETOKEN) + "=";
                    beginIndex = location.toLowerCase().indexOf(key);
                    if (beginIndex > 0) {
                        val = location.substring(beginIndex + key.length());
                        n = val.indexOf("&");
                        if (n > 0) {
                            val = val.substring(0, n);
                        }
                        site2pstoretoken = val;
                        ret = new SiteToken();
                        ret.site2pstoretoken = site2pstoretoken;
                    }
                }
                if (headerName.equals("Set-Cookie")) {
                    val = urlConnection.getHeaderField(i);
                    cookie = val = val.substring(0, val.indexOf(59));
                    if (cookie.startsWith("OAM_REQ")) {
                        n1 = "OAM_REQ".length() + 1;
                        n2 = cookie.indexOf(59);
                        ret.OAM_REQ = cookie.substring(n1, n2 > 0 ? n2 : cookie.length());
                    }
                }
                ++i;
            }
            if (ret != null && ret.isComplete()) {
                return ret;
            }
            if (location == null) continue;
            urlConnection = OTNDownloadUtil.newConnection(location, proxy, "GET");
            urlConnection.connect();
            code = urlConnection.getResponseCode();
lbl56:
            // 3 sources

            ** while (code > 300 && code < 400)
        }
lbl57:
        // 1 sources

        if (code == 200) {
            OTNDownloadUtil.trace("================================= OAM_REQ =============================");
            i = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
                OTNDownloadUtil.trace(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
                if (headerName.equals("Set-Cookie")) {
                    val = urlConnection.getHeaderField(i);
                    cookie = val = val.substring(0, val.indexOf(59));
                    if (cookie.startsWith("OAM_REQ")) {
                        n1 = "OAM_REQ".length() + 1;
                        n2 = cookie.indexOf(59);
                        ret.OAM_REQ = cookie.substring(n1, n2 > 0 ? n2 : cookie.length());
                    }
                }
                ++i;
            }
            if (ret.OAM_REQ == null && (n = (html = OTNDownloadUtil.readResponse(urlConnection)).indexOf(token = "name=\"OAM_REQ\" value=\"")) > 0) {
                text = html.substring(n + token.length());
                ret.OAM_REQ = text = text.substring(0, text.indexOf(34));
            }
        }
        return ret;
    }

    private static void trace(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static boolean handleSSO(Proxy proxy, String userName, String password, Set<String> cookies) throws IOException {
        boolean ret = false;
        SiteToken token = OTNDownloadUtil.getSiteToken(proxy);
        if (token == null || token.OAM_REQ == null) {
            String msg = "Error retrieve OAM_REQ or Site2pstoretoken from Oracel Access Manager ";
            throw new IOException(msg);
        }
        HttpURLConnection urlConnection = OTNDownloadUtil.newConnection(OTN_LOGIN_HANDLER, proxy, POST);
        String urlParameters = "";
        urlParameters = String.valueOf(urlParameters) + "&ssousername=";
        urlParameters = String.valueOf(urlParameters) + userName;
        urlParameters = String.valueOf(urlParameters) + "&password=";
        urlParameters = String.valueOf(urlParameters) + password;
        urlParameters = String.valueOf(urlParameters) + "&v=v1.4";
        urlParameters = String.valueOf(urlParameters) + "&p_submit_url=/sso/auth";
        urlParameters = String.valueOf(urlParameters) + "&site2pstoretoken=" + token.site2pstoretoken;
        urlParameters = String.valueOf(urlParameters) + "&OAM_REQ=" + token.OAM_REQ;
        urlConnection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes(StandardCharsets.UTF_8).length));
        urlConnection.setRequestProperty("Content-Language", "en-US");
        DataOutputStream wr = new DataOutputStream(urlConnection.getOutputStream());
        wr.writeBytes(urlParameters);
        wr.flush();
        wr.close();
        int code = urlConnection.getResponseCode();
        String headerName = null;
        if (code == 401) {
            throw new IOException("Unauthorized request. Please check your username and password");
        }
        if (code == 200) {
            int i = 1;
            while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
                if (debug) {
                    System.out.println(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
                }
                ++i;
            }
            if (debug) {
                String html = OTNDownloadUtil.readResponse(urlConnection);
                System.err.println(html);
            }
            throw new IOException("Unauthorized request. Please check your username and password");
        }
        if (code == 302) {
            OTNDownloadUtil.addCookies(urlConnection, cookies);
            while (code == 302) {
                String location = urlConnection.getHeaderField("Location");
                if (location != null && location.indexOf("osso_login_success") > 0) {
                    OTNDownloadUtil.trace("osso_login_success");
                }
                urlConnection = OTNDownloadUtil.newConnection(location, proxy, GET);
                urlConnection.connect();
                code = urlConnection.getResponseCode();
                OTNDownloadUtil.addCookies(urlConnection, cookies);
            }
            if (code == 200) {
                return true;
            }
        }
        return ret;
    }

    public static HttpURLConnection getConnection(String fileUrl, Proxy proxy, String userName, String password) throws IOException {
        TreeSet<String> cookies = new TreeSet<String>();
        boolean loginSuccessfully = OTNDownloadUtil.handleSSO(proxy, userName, password, cookies);
        if (loginSuccessfully) {
            String location = ADF_DOWNLOAD_URL;
            cookies.add(" gpw_e24=http%3A%2F%2Fwww.oracle.com%2Ftechnetwork%2Fdeveloper-tools%2Fadf%2Fdownloads%2Findex.html;");
            cookies.add(" s_cc=true;");
            cookies.add(" testSessionCookie=Enabled;");
            cookies.add(" oraclelicense=accept-dbindex-cookie;");
            cookies.add(" s_sq=oracleotnlive%2Coracleglobal%3D%2526pid%253Dotn%25253Aen-us%25253A%25252Fdeveloper-tools%25252Fadf%25252Fdownloads%25252F%2526pidt%253D1%2526oid%253Dfunctiononclick(event)%25257BacceptAgreement(window.self)%25253B%25257D%2526oidt%253D2%2526ot%253DRADIO;");
            cookies.add(" ARU_LANG=US;");
            HttpURLConnection urlConnection = OTNDownloadUtil.newConnection(location, proxy, GET);
            urlConnection.addRequestProperty("Cookie", OTNDownloadUtil.toString(cookies));
            int code = urlConnection.getResponseCode();
            while (code > 300 && code < 400) {
                OTNDownloadUtil.addCookies(urlConnection, cookies);
                location = urlConnection.getHeaderField("Location");
                if (location == null) continue;
                urlConnection = OTNDownloadUtil.newConnection(location, proxy, GET);
                urlConnection.connect();
                code = urlConnection.getResponseCode();
            }
            location = fileUrl;
            urlConnection = OTNDownloadUtil.newConnection(location, proxy, GET);
            urlConnection.addRequestProperty("Cookie", OTNDownloadUtil.toString(cookies));
            urlConnection.connect();
            code = urlConnection.getResponseCode();
            while (code > 300 && code < 400) {
                OTNDownloadUtil.addCookies(urlConnection, cookies);
                location = urlConnection.getHeaderField("Location");
                if (location == null) continue;
                urlConnection = OTNDownloadUtil.newConnection(location, proxy, GET);
                urlConnection.addRequestProperty("Cookie", OTNDownloadUtil.toString(cookies));
                urlConnection.connect();
                code = urlConnection.getResponseCode();
            }
            if (code == 200) {
                return urlConnection;
            }
        }
        return null;
    }

    private static String toString(Set<String> cookies) {
        StringBuilder sb = new StringBuilder();
        for (String s : cookies) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static void addCookies(HttpURLConnection urlConnection, Set<String> cookies) {
        String headerName = null;
        int i = 1;
        while ((headerName = urlConnection.getHeaderFieldKey(i)) != null) {
            OTNDownloadUtil.trace(String.valueOf(headerName) + "=" + urlConnection.getHeaderField(i));
            if (headerName.equals("Set-Cookie")) {
                String val = urlConnection.getHeaderField(i);
                if ((val = val.substring(0, val.indexOf(59))).startsWith("OHS-edelivery.oracle.com-80")) {
                    OTNDownloadUtil.trace("Found OHS cookie =" + val);
                }
                cookies.add(String.valueOf(val) + "; ");
            }
            ++i;
        }
    }

    private static HttpURLConnection newConnection(String location, Proxy proxy, String method) throws IOException {
        OTNDownloadUtil.trace("=============================================================================");
        OTNDownloadUtil.trace(String.valueOf(method) + " " + location);
        OTNDownloadUtil.trace("=============================================================================");
        HttpURLConnection urlConnection = null;
        URL newUrl = new URL(location);
        urlConnection = proxy != null ? (HttpURLConnection)newUrl.openConnection(proxy) : (HttpURLConnection)newUrl.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setRequestProperty("User-Agent", USER_AGENT);
        urlConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        urlConnection.setInstanceFollowRedirects(false);
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setUseCaches(false);
        urlConnection.setDoInput(true);
        if (POST.equals(method)) {
            urlConnection.setDoOutput(true);
        }
        return urlConnection;
    }

    public static void writeFile(URLConnection urlConnection, File destFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = urlConnection.getInputStream();
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[262144];
            int count = 0;
            int bytesTransfered = 0;
            int n = 1;
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
                if ((bytesTransfered += count) <= n * 1024 * 1024) continue;
                System.out.print(".");
                System.out.flush();
                if (++n % 80 != 0) continue;
                System.out.println();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String readResponse(URLConnection urlConnection) throws IOException {
        InputStream in = null;
        StringBuilder ret = new StringBuilder();
        try {
            in = urlConnection.getInputStream();
            byte[] buffer = new byte[16384];
            int count = 0;
            while ((count = in.read(buffer)) != -1) {
                String msg = new String(buffer, 0, count, "UTF-8");
                ret.append(msg);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("OTNDownloadUtil [url] [userName] [passwd] [destination directory] [-verbose]");
        } else {
            String url = args[0];
            String userName = args[1];
            String password = args[2];
            File destDir = new File(args[3]);
            if (args.length > 4 && "-verbose".equals(args[4])) {
                debug = true;
            }
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            Proxy proxy = null;
            if (proxyHost != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
            }
            System.err.println(url);
            HttpURLConnection urlConnection = OTNDownloadUtil.getConnection(url, proxy, userName, password);
            if (urlConnection != null) {
                int size = urlConnection.getContentLength();
                System.out.println("Downloading from : " + urlConnection.getURL().toString());
                System.out.println("Total size = " + size / 0x100000 + "MB");
                String fileName = url.substring(url.lastIndexOf(47) + 1);
                OTNDownloadUtil.writeFile(urlConnection, new File(destDir, fileName));
            } else {
                System.out.println("Downloading URL not found");
            }
        }
    }

    static class SiteToken {
        String OAM_REQ = null;
        String site2pstoretoken = null;

        SiteToken() {
        }

        public boolean isComplete() {
            return this.OAM_REQ != null && this.site2pstoretoken != null;
        }
    }
}

