/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUpdater;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RemoveContextParamOperation
extends AbstractBasicOperation {
    private final IProject project;
    private final String contextParamName;
    private final String contextParamValue;

    public RemoveContextParamOperation(IProject project, String contextParamName, String contextParamValue) {
        super(NLS.bind((String)Strings.operationLabel, (Object)contextParamName));
        this.project = project;
        this.contextParamName = contextParamName;
        this.contextParamValue = contextParamValue;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        try {
            WebXmlUpdater updater = new WebXmlUpdater(this.project, ProgressMonitorUtil.submon(monitor, 1));
            updater.removeContextParam(this.contextParamName, this.contextParamValue);
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String operationLabel;

        static {
            Strings.initializeMessages((String)RemoveContextParamOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

