/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.osgi.util.NLS;

public class InstallFacetLibrariesOperation
extends AbstractBasicOperation {
    private final IProject project;
    private final LibraryFacetInstallConfig config;

    public InstallFacetLibrariesOperation(IProject project, LibraryFacetInstallConfig config) {
        super(NLS.bind((String)Strings.installFacetLibrariesOperationLabel, (Object)config.getProjectFacetVersion().getProjectFacet().getId()));
        this.project = project;
        this.config = config;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        try {
            try {
                if (this.config.getFacetedProjectWorkingCopy().getProject() == null) {
                    this.config.getFacetedProjectWorkingCopy().setProjectName(this.project.getName());
                }
                this.config.getLibraryInstallDelegate().execute(ProgressMonitorUtil.submon(monitor, 1));
            }
            catch (CoreException e) {
                throw new ExecutionException("Failed to install facet libraries: " + e.getLocalizedMessage());
            }
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String installFacetLibrariesOperationLabel;

        static {
            Strings.initializeMessages((String)InstallFacetLibrariesOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

