/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class DeleteFileOperation
extends AbstractBasicOperation {
    private final IFile file;

    public DeleteFileOperation(IProject project, String fileToDeleteInProject) {
        this(project, fileToDeleteInProject, false);
    }

    public DeleteFileOperation(IProject project, String fileToDeleteInProject, boolean enabled) {
        this(project.getFile(fileToDeleteInProject), enabled);
    }

    public DeleteFileOperation(IFile file) {
        this(file, false);
    }

    public DeleteFileOperation(IFile file, boolean enabled) {
        super(NLS.bind((String)Strings.deleteFileOperationLabel, (Object)file.getProjectRelativePath().toPortableString()));
        this.file = file;
        this.setSelected(enabled);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        try {
            try {
                this.file.delete(false, ProgressMonitorUtil.submon(monitor, 1));
            }
            catch (CoreException e) {
                throw new ExecutionException("Could not delete file " + this.file.getName(), (Throwable)e);
            }
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String deleteFileOperationLabel;

        static {
            Strings.initializeMessages((String)DeleteFileOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

