/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import java.io.IOException;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class CopyFileOperation
extends AbstractBasicOperation {
    private final Bundle sourceBundle;
    private final IPath sourceFilePathInBundle;
    private final IContainer targetProject;
    private final IPath pathInTargetProject;
    private final boolean overwrite;
    private final IPath targetFileName;
    private final IFile targetFile;

    public CopyFileOperation(Plugin sourcePlugin, String sourceFilePathInBundle, IContainer targetProject, String pathInTargetProject, boolean overwrite) throws CoreException {
        super("");
        if (sourceFilePathInBundle == null) {
            throw new IllegalArgumentException("CopyFilesOperation expects a non-null source-file path in the source-bundle.");
        }
        this.sourceBundle = sourcePlugin.getBundle();
        this.sourceFilePathInBundle = new Path(sourceFilePathInBundle);
        this.targetProject = targetProject;
        this.pathInTargetProject = new Path(pathInTargetProject == null ? "" : pathInTargetProject);
        this.overwrite = overwrite;
        this.targetFileName = new Path(this.sourceFilePathInBundle.lastSegment());
        this.targetFile = targetProject.getFolder(this.pathInTargetProject).getFile(this.targetFileName);
        if (this.targetFile.isAccessible()) {
            this.setLabel(NLS.bind((String)Strings.overwriteFileLabel, (Object)this.targetFileName, (Object)pathInTargetProject));
            this.setSelected(false);
        } else {
            this.setLabel(NLS.bind((String)Strings.createFileLabel, (Object)this.targetFileName, (Object)pathInTargetProject));
            this.setSelected(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 2);
        try {
            IFolder targetFolder = this.targetProject.getFolder(this.pathInTargetProject);
            try {
                if (this.targetFile.exists()) {
                    if (!this.overwrite) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    this.targetFile.delete(false, ProgressMonitorUtil.submon(monitor, 1));
                } else if (!targetFolder.exists()) {
                    targetFolder = CopyFileOperation.makeFolders(this.targetProject, this.pathInTargetProject, ProgressMonitorUtil.submon(monitor, 1));
                } else {
                    ProgressMonitorUtil.worked(monitor, 1);
                }
                this.targetFile.create(FileLocator.openStream((Bundle)this.sourceBundle, (IPath)this.sourceFilePathInBundle, (boolean)false), false, ProgressMonitorUtil.submon(monitor, 1));
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                throw new ExecutionException("Failed to create file " + this.targetFileName + " in " + targetFolder, (Throwable)e);
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to create file " + this.targetFileName + " in " + targetFolder, (Throwable)e);
            }
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
    }

    private static IFolder makeFolders(IContainer root, IPath path, IProgressMonitor monitor) throws CoreException {
        int segmentCount = path.segmentCount();
        ProgressMonitorUtil.beginTask(monitor, segmentCount);
        try {
            if (segmentCount == 0) {
                IFolder iFolder = root.getFolder(path);
                return iFolder;
            }
            IFolder firstSegmentFolder = root.getFolder((IPath)new Path(path.segment(0)));
            if (!firstSegmentFolder.isAccessible()) {
                firstSegmentFolder.create(0, true, ProgressMonitorUtil.submon(monitor, 1));
            }
            IFolder iFolder = CopyFileOperation.makeFolders((IContainer)firstSegmentFolder, path.removeFirstSegments(1), ProgressMonitorUtil.submon(monitor, segmentCount - 1));
            return iFolder;
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
    }

    private static final class Strings
    extends NLS {
        public static String overwriteFileLabel;
        public static String createFileLabel;

        static {
            Strings.initializeMessages((String)CopyFileOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

