/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import java.util.List;
import oracle.eclipse.tools.common.operations.AbstractCompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CompoundOperation
extends AbstractCompoundOperation {
    public CompoundOperation(String label) {
        super(label);
    }

    public CompoundOperation(String label, Object[] operationObjects) {
        this(label);
        Object[] objectArray = operationObjects;
        int n = operationObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation = objectArray[n2];
            if (!(operation instanceof IOperation)) {
                throw new IllegalArgumentException("CompositeOperation expected an operation of type IOperation");
            }
            this.add((IOperation)operation);
            ++n2;
        }
    }

    public CompoundOperation(String label, List<IOperation> operationList) {
        super(label, operationList);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, this.operationList.size());
        IStatus compositeStatus = Status.OK_STATUS;
        try {
            for (IOperation operation : this.operationList) {
                String errorMessage = "Operation failed: " + operation.getLabel();
                try {
                    if (operation.execute(ProgressMonitorUtil.submon(monitor, 1), info).getSeverity() == 0) continue;
                    LoggingService.logError("oracle.eclipse.tools.common", errorMessage);
                    compositeStatus = new Status(4, "oracle.eclipse.tools.common", errorMessage);
                }
                catch (ExecutionException e) {
                    LoggingService.logError("oracle.eclipse.tools.common", String.valueOf(errorMessage) + ". " + e.getLocalizedMessage());
                    compositeStatus = new Status(4, "oracle.eclipse.tools.common", errorMessage);
                }
            }
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return compositeStatus;
    }
}

