/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.content.AnnotationContentTypeDescription;
import oracle.eclipse.tools.common.content.AnnotationContentTypeSpec;
import oracle.eclipse.tools.common.content.ContentPlugin;
import oracle.eclipse.tools.common.content.TopLevelAnnotationContentDescriber;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public final class TopLevelAnnotationLexer {
    public static final TopLevelAnnotationLexer globalLexer = new TopLevelAnnotationLexer();
    private final Map<String, AnnotationContentTypeSpec> contentTypeSpecs = new HashMap<String, AnnotationContentTypeSpec>();
    private final Map<String, AnnotationContentTypeDescription> contentTypeDesc = new HashMap<String, AnnotationContentTypeDescription>();
    private InputStream cachedStream;
    private Reader cachedReader;
    private final Pattern topLevelDeclPattern = Pattern.compile("(?:\\A| )(?:class |[^@ ] *interface )");
    private final Pattern ignoreLinePattern = Pattern.compile("\\A\\*|\\A/\\*|\\A//|\\Apackage |\\Aimport ");
    private final IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
    private final Map<CharBuffer, char[]> nameToPackage = new HashMap<CharBuffer, char[]>();
    private final List<char[]> wildCardPackages = new ArrayList<char[]>();
    private StringBuilder packageDecl;
    private final Map<CharBuffer, char[]> annotationToElementValuePairs = new HashMap<CharBuffer, char[]>();
    protected static final int BLOCK_SIZE = 1024;

    protected synchronized void addAnnotationContentTypeSpec(AnnotationContentTypeSpec spec) {
        assert (spec != null) : "AnnotationContentTypeSpec cannot be null";
        this.contentTypeSpecs.put(spec.getContentTypeId(), spec);
        this.cachedStream = null;
        this.cachedReader = null;
    }

    protected synchronized int describe(Reader contents, String contentTypeId, IContentDescription description) throws IOException {
        if (this.contentTypeSpecs.isEmpty()) {
            return 0;
        }
        boolean parseReader = false;
        if (this.cachedStream != null || this.cachedReader != contents) {
            parseReader = true;
            this.cachedReader = contents;
            this.cachedStream = null;
        }
        if (parseReader) {
            this.describeInternal(contents);
        }
        int result = this.describeContentType(contentTypeId, description);
        return result;
    }

    protected synchronized int describe(InputStream contents, String contentTypeId, IContentDescription description) throws IOException {
        if (this.contentTypeSpecs.isEmpty()) {
            return 0;
        }
        boolean parseStream = false;
        if (this.cachedReader != null || this.cachedStream != contents) {
            parseStream = true;
            this.cachedStream = contents;
            this.cachedReader = null;
        }
        if (parseStream) {
            String encoding = ResourcesPlugin.getEncoding();
            this.describeInternal(new InputStreamReader(contents, encoding));
        }
        int result = this.describeContentType(contentTypeId, description);
        return result;
    }

    private int describeContentType(String contentTypeId, IContentDescription description) throws IOException {
        AnnotationContentTypeDescription annotationDesc = this.contentTypeDesc.get(contentTypeId);
        if (annotationDesc == null) {
            return 0;
        }
        AnnotationContentTypeSpec spec = this.contentTypeSpecs.get(contentTypeId);
        if (description != null) {
            if (spec.storeAnnotation()) {
                description.setProperty(TopLevelAnnotationContentDescriber.ANNOTATION_TYPE_PROPERTY, (Object)annotationDesc.getAnnotation());
            }
            char[] elementValuePairs = annotationDesc.getElementValuePairs();
            if (spec.storeElementValuePairs() && elementValuePairs != null) {
                description.setProperty(TopLevelAnnotationContentDescriber.ELEMENT_VALUE_PAIRS_PROPERTY, (Object)new String(elementValuePairs));
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeInternal(Reader contents) throws IOException {
        LineNumberReader reader = new LineNumberReader(contents);
        char[] content = this.peek(reader);
        this.scanner.setSource(content);
        this.initDataStructures();
        boolean hitTopLevel = false;
        try {
            hitTopLevel = this.findTopLevelAnnotationTypes();
        }
        catch (InvalidInputException invalidInputException) {
            hitTopLevel = false;
        }
        catch (Exception exception) {
            LoggingService.logError(ContentPlugin.getDefault(), ContentPlugin.getResourceString("error-finding-annotations"));
            return;
        }
        if (!hitTopLevel) {
            content = this.readFully(reader, content);
            this.scanner.setSource(content);
            this.initDataStructures();
            try {
                hitTopLevel = this.findTopLevelAnnotationTypes();
            }
            catch (InvalidInputException invalidInputException) {
                return;
            }
            catch (Exception exception) {
                LoggingService.logError(ContentPlugin.getDefault(), ContentPlugin.getResourceString("error-finding-annotations"));
                return;
            }
            if (!hitTopLevel) {
                return;
            }
        }
        for (CharBuffer annotationType : this.annotationToElementValuePairs.keySet()) {
            List<CharSequence> fullyQualifiedAnnotationTypes = this.qualifyAnnotationType(annotationType);
            for (CharSequence fullyQualifiedAnnotationType : fullyQualifiedAnnotationTypes) {
                Map<String, AnnotationContentTypeSpec> map = this.contentTypeSpecs;
                synchronized (map) {
                    for (AnnotationContentTypeSpec spec : this.contentTypeSpecs.values()) {
                        Matcher matcher = spec.getAnnotationPattern().matcher(fullyQualifiedAnnotationType);
                        if (!matcher.find()) continue;
                        AnnotationContentTypeDescription annotationDesc = new AnnotationContentTypeDescription();
                        this.contentTypeDesc.put(spec.getContentTypeId(), annotationDesc);
                        if (spec.storeAnnotation()) {
                            annotationDesc.setAnnotation(fullyQualifiedAnnotationType.toString());
                        }
                        char[] elementValuePairs = this.annotationToElementValuePairs.get(annotationType);
                        if (!spec.storeElementValuePairs() || elementValuePairs == null) continue;
                        annotationDesc.setElementValuePairs(elementValuePairs);
                    }
                }
            }
        }
    }

    private void initDataStructures() {
        this.contentTypeDesc.clear();
        this.nameToPackage.clear();
        this.wildCardPackages.clear();
        this.annotationToElementValuePairs.clear();
        this.packageDecl = new StringBuilder();
    }

    private List<CharSequence> qualifyAnnotationType(CharBuffer annotationType) {
        char[] annotationTypeChars = annotationType.array();
        int lastIndex = CharOperation.lastIndexOf((char)'.', (char[])annotationTypeChars);
        ArrayList<CharSequence> qualifiedTypes = new ArrayList<CharSequence>();
        if (lastIndex < 0) {
            char[] pkg = this.nameToPackage.get(annotationType);
            if (pkg != null) {
                qualifiedTypes.add(this.getQualifiedType(annotationTypeChars, pkg));
            } else {
                this.addPackageAndWildCards(qualifiedTypes, annotationTypeChars);
            }
        } else {
            qualifiedTypes.add(annotationType);
            int firstIndex = CharOperation.indexOf((char)'.', (char[])annotationTypeChars);
            if (firstIndex == lastIndex) {
                char[] pkg = this.nameToPackage.get(annotationType.subSequence(0, firstIndex));
                if (pkg != null) {
                    qualifiedTypes.add(this.getQualifiedType(annotationTypeChars, pkg));
                } else {
                    this.addPackageAndWildCards(qualifiedTypes, annotationTypeChars);
                }
            }
        }
        return qualifiedTypes;
    }

    private void addPackageAndWildCards(List<CharSequence> qualifiedTypes, char[] annotationType) {
        for (char[] pkg : this.wildCardPackages) {
            qualifiedTypes.add(this.getQualifiedType(annotationType, pkg));
        }
        qualifiedTypes.add(this.getQualifiedType(annotationType, this.packageDecl.toString().toCharArray()));
    }

    private CharSequence getQualifiedType(char[] name, char[] pkg) {
        return CharBuffer.wrap(CharOperation.concat((char[])pkg, (char[])name, (char)'.'));
    }

    private char[] peek(BufferedReader reader) throws IOException {
        String line;
        StringBuilder buff = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            String trimmed = line.trim();
            buff.append(line);
            buff.append("\n");
            if (!this.ignoreLinePattern.matcher(trimmed).find() && this.topLevelDeclPattern.matcher(trimmed).find()) break;
        }
        return buff.toString().toCharArray();
    }

    private char[] peekFast(BufferedReader reader) throws IOException {
        int length = 0;
        char[] content = new char[2048];
        char[] temp = new char[1024];
        int numRead = 0;
        int lineEnd = 0;
        while ((numRead = reader.read(temp)) >= 0) {
            if (numRead <= 0) continue;
            if (content.length - length - numRead < 0) {
                char[] newContent = new char[content.length + 2048];
                System.arraycopy(content, 0, newContent, 0, length);
                content = newContent;
            }
            System.arraycopy(temp, 0, content, length, numRead);
            length += numRead;
            int i = lineEnd + 1;
            while (i < length + numRead) {
                if (content[i] == '\n' || content[i] == '\r' && i + 1 < content.length && content[i + 1] == '\n') {
                    char[] lineChars = new char[i - lineEnd];
                    System.arraycopy(content, lineEnd + 1, lineChars, 0, lineChars.length);
                    String lineStr = new String(lineChars).trim();
                    if (!this.ignoreLinePattern.matcher(lineStr).find() && this.topLevelDeclPattern.matcher(lineStr).find()) {
                        return this.stripOffUnread(content, length);
                    }
                    lineEnd = i;
                }
                ++i;
            }
        }
        return this.stripOffUnread(content, length);
    }

    private char[] stripOffUnread(char[] content, int numRead) {
        if (content.length > numRead) {
            char[] newContent = new char[numRead];
            System.arraycopy(content, 0, newContent, 0, numRead);
            return newContent;
        }
        return content;
    }

    protected char[] readFully(Reader reader, char[] currentlyRead) throws IOException {
        char[] newContent;
        int length = 0;
        char[] content = null;
        if (currentlyRead != null) {
            content = new char[currentlyRead.length + 2048];
            System.arraycopy(currentlyRead, 0, content, 0, currentlyRead.length);
            length = currentlyRead.length;
        } else {
            content = new char[2048];
        }
        char[] temp = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(temp)) >= 0) {
            if (numRead <= 0) continue;
            if (content.length - length - numRead < 0) {
                newContent = new char[content.length + 2048];
                System.arraycopy(content, 0, newContent, 0, length);
                content = newContent;
            }
            System.arraycopy(temp, 0, content, length, numRead);
            length += numRead;
        }
        if (content.length > length) {
            newContent = new char[length];
            System.arraycopy(content, 0, newContent, 0, length);
            content = newContent;
        }
        return content;
    }

    private boolean findTopLevelAnnotationTypes() throws InvalidInputException {
        boolean hitAt = false;
        boolean buildingAnnotationType = false;
        boolean buildingPackage = false;
        boolean buildingImport = false;
        boolean skippingExtraIdentifiers = false;
        char[] importChars = null;
        char[] annotationTypeChars = null;
        int parenCount = 0;
        int elementValueStartIndex = 0;
        boolean hitClassOrInterface = false;
        boolean hitTopLevel = false;
        int nextToken = 1000;
        while (true) {
            int lastToken = nextToken;
            nextToken = this.scanner.getNextToken();
            if (nextToken == 158) break;
            if (buildingPackage) {
                if (nextToken == 5 || nextToken == 6) {
                    this.packageDecl.append(this.scanner.getCurrentTokenSource());
                    continue;
                }
                buildingPackage = false;
            }
            if (buildingImport) {
                int lastIndex;
                if (nextToken == 94) continue;
                if (nextToken == 5 || nextToken == 6 || nextToken == 8) {
                    importChars = CharOperation.concat(importChars, (char[])this.scanner.getCurrentTokenSource());
                    continue;
                }
                if (importChars != null && (lastIndex = CharOperation.lastIndexOf((char)'.', (char[])importChars)) > 0) {
                    char[] name = CharOperation.subarray((char[])importChars, (int)(lastIndex + 1), (int)-1);
                    char[] pkg = CharOperation.subarray((char[])importChars, (int)0, (int)lastIndex);
                    if (name.length == 1 && name[0] == '*') {
                        this.wildCardPackages.add(pkg);
                    } else {
                        this.nameToPackage.put(CharBuffer.wrap(name), pkg);
                    }
                }
                buildingImport = false;
            }
            if (hitAt) {
                if (nextToken == 5) {
                    annotationTypeChars = this.scanner.getCurrentTokenSource();
                    buildingAnnotationType = true;
                } else if (nextToken == 180) {
                    hitTopLevel = true;
                }
                hitAt = false;
                continue;
            }
            if (buildingAnnotationType) {
                if (!(nextToken != 5 && nextToken != 6 || skippingExtraIdentifiers)) {
                    if (lastToken == nextToken) {
                        skippingExtraIdentifiers = true;
                        continue;
                    }
                    annotationTypeChars = CharOperation.concat((char[])annotationTypeChars, (char[])this.scanner.getCurrentTokenSource());
                    continue;
                }
                buildingAnnotationType = false;
                skippingExtraIdentifiers = false;
                if (nextToken == 7) {
                    elementValueStartIndex = this.scanner.getCurrentTokenStartPosition();
                    parenCount = (short)(parenCount + 1);
                    continue;
                }
                if (annotationTypeChars != null) {
                    this.annotationToElementValuePairs.put(CharBuffer.wrap(annotationTypeChars), null);
                    annotationTypeChars = null;
                }
            }
            if (parenCount > 0) {
                if (nextToken == 86) {
                    if ((parenCount = (int)((short)(parenCount - 1))) != 0) continue;
                    char[] elementValuePairs = new char[this.scanner.getCurrentTokenEndPosition() - elementValueStartIndex + 1];
                    System.arraycopy(this.scanner.getSource(), elementValueStartIndex, elementValuePairs, 0, elementValuePairs.length);
                    this.annotationToElementValuePairs.put(CharBuffer.wrap(annotationTypeChars), elementValuePairs);
                    annotationTypeChars = null;
                    elementValueStartIndex = 0;
                    continue;
                }
                if (nextToken != 7) continue;
                parenCount = (short)(parenCount + 1);
                continue;
            }
            switch (nextToken) {
                case 214: {
                    buildingPackage = true;
                    break;
                }
                case 191: {
                    buildingImport = true;
                    importChars = null;
                    break;
                }
                case 401: {
                    hitAt = true;
                    annotationTypeChars = null;
                    break;
                }
                case 165: {
                    hitClassOrInterface = true;
                    hitTopLevel = true;
                    break;
                }
                case 180: {
                    hitClassOrInterface = true;
                    hitTopLevel = true;
                    break;
                }
                case 400: {
                    hitTopLevel = true;
                    break;
                }
                case 98: {
                    break;
                }
                case 99: {
                    break;
                }
                case 101: {
                    break;
                }
                case 102: {
                    break;
                }
                case 103: {
                    break;
                }
                case 94: {
                    break;
                }
                case 104: {
                    break;
                }
                default: {
                    this.annotationToElementValuePairs.clear();
                }
            }
            if (hitClassOrInterface) break;
        }
        return hitTopLevel;
    }
}

