/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.content;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;

public final class AnnotationContentTypeSpec {
    private final String _contentTypeId;
    private final QualifiedName _qualifiedName;
    private final String _annotationRegExp;
    private final Pattern _annotationPattern;
    private final boolean _storeAnnotation;
    private final boolean _storeElementValuePairs;

    protected AnnotationContentTypeSpec(String contentTypeId, String annotationRegExp, boolean storeAnnotation, boolean storeElementValuePairs) {
        assert (contentTypeId != null) : "contentTypeID cannot be null";
        assert (annotationRegExp != null) : "annotationRegExp cannot be null";
        this._contentTypeId = contentTypeId;
        this._qualifiedName = new QualifiedName(null, contentTypeId);
        this._annotationRegExp = annotationRegExp;
        this._annotationPattern = Pattern.compile(annotationRegExp);
        this._storeAnnotation = storeAnnotation;
        this._storeElementValuePairs = storeElementValuePairs;
    }

    protected String getContentTypeId() {
        return this._contentTypeId;
    }

    protected QualifiedName getQualifiedName() {
        return this._qualifiedName;
    }

    protected String getAnnotationRegExp() {
        return this._annotationRegExp;
    }

    protected Pattern getAnnotationPattern() {
        return this._annotationPattern;
    }

    protected boolean storeAnnotation() {
        return this._storeAnnotation;
    }

    protected boolean storeElementValuePairs() {
        return this._storeElementValuePairs;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Specification for content type ID: " + this._contentTypeId);
        buff.append("\n\tAnnotation regexp: " + this._annotationRegExp);
        buff.append("\n\tStore annotation: " + this._storeAnnotation);
        buff.append("\n\tStore element value pairs: " + this._storeElementValuePairs);
        return buff.toString();
    }
}

