/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.builder.BuilderNodePrefs;
import oracle.eclipse.tools.common.builder.BuilderPlugin;
import oracle.eclipse.tools.common.builder.BuilderUtils;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class BuilderPathPrefs
extends BuilderNodePrefs
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String DEFAULT_OUTPUT_PREF = "default_output";
    public static final String DEFAULT_OUTPUT = "build";
    public static final String DEFAULT_SRC = "src";
    public static final String USE_JAVA_SRC_PATHS_PREF = "use_java_src_paths";
    public static final boolean DEFAULT_USE_JAVA_SRC_PATHS = true;
    public static final String SOURCE_PATHS_FILE = "SourcePaths";
    public static final String SOURCE_PATHS_MODIFIED_PREF = "source_paths_modified";
    protected IProject fProject;
    protected List<IClasspathEntry> fSourcePaths = new ArrayList<IClasspathEntry>();
    protected boolean sourcePathsModified = true;

    public BuilderPathPrefs(String storageId, IScopeContext scopeContext) {
        super(storageId, scopeContext);
    }

    public BuilderPathPrefs(IProject project, String storageId) {
        super(project, storageId);
        this.fProject = project;
    }

    protected boolean saveSubclassData() {
        return true;
    }

    protected void loadSubclassData() {
    }

    @Override
    public boolean save() {
        if (!this.saveSourcePaths()) {
            return false;
        }
        if (!this.saveSubclassData()) {
            return false;
        }
        return super.save();
    }

    protected boolean saveSourcePaths() {
        assert (this.fPrefsNode != null) : "Prefs node cannot be null";
        assert (this.fSourcePaths != null) : "Source paths cannot be null";
        assert (this.fProject != null) : "Project cannot be null";
        IFile sourcePathFile = this.getSourcePathsFile();
        try {
            BuilderUtils.writeClasspaths(this.fSourcePaths, sourcePathFile, this.fProject);
            this.fPrefsNode.putBoolean(SOURCE_PATHS_MODIFIED_PREF, !this.fPrefsNode.getBoolean(SOURCE_PATHS_MODIFIED_PREF, false));
        }
        catch (IOException ioe) {
            LoggingService.logException(BuilderPlugin.getDefault(), (Throwable)ioe, BuilderPlugin.getString("error-saving-file", sourcePathFile.getFullPath()));
            return false;
        }
        catch (CoreException ce) {
            LoggingService.logException(BuilderPlugin.getDefault(), (Throwable)ce, BuilderPlugin.getString("error-saving-file", sourcePathFile.getFullPath()));
            return false;
        }
        catch (IllegalStateException ise) {
            LoggingService.logException(BuilderPlugin.getDefault(), (Throwable)ise, BuilderPlugin.getString("error-saving-file", sourcePathFile.getFullPath()));
            return false;
        }
        return true;
    }

    public IFile getSourcePathsFile() {
        assert (this.fProject != null) : "Project cannot be null";
        IPath sourcePathsFilePath = this.fScopeContext.getLocation();
        sourcePathsFilePath = sourcePathsFilePath.append(String.valueOf(this.fStorageId) + SOURCE_PATHS_FILE);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(sourcePathsFilePath);
    }

    @Override
    public void load() {
        this.loadSourcePaths();
        this.loadSubclassData();
    }

    public void trackSourcePathUpdates() {
        this.fPrefsNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    protected String getOutputDefault() {
        return DEFAULT_OUTPUT;
    }

    private synchronized void loadSourcePaths() {
        assert (this.fProject != null) : "Project cannot be null";
        IFile sourcePathFile = this.getSourcePathsFile();
        try {
            this.fSourcePaths = BuilderUtils.readClasspaths(sourcePathFile, this.fProject);
        }
        catch (IOException ioe) {
            LoggingService.logException(BuilderPlugin.getDefault(), (Throwable)ioe, BuilderPlugin.getString("error-reading-file", sourcePathFile.getFullPath()));
        }
        this.sourcePathsModified = false;
    }

    public abstract IPath getDefaultCustomSrcPath();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOnSourcePath(IResource resource) {
        try {
            IClasspathEntry entry;
            if (this.useJavaSrcPaths() && this.fProject != null) {
                return this.isOnJavaBuildPath(resource);
            }
            IPath path = resource.getFullPath();
            boolean isFolderPath = resource.getType() == 2;
            List<IClasspathEntry> srcPaths = this.getSourcePaths();
            Iterator<IClasspathEntry> iterator = srcPaths.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!BuilderPathPrefs.isOnClasspath(entry = iterator.next(), path, isFolderPath));
            return true;
        }
        catch (IllegalStateException ise) {
            LoggingService.logException((Plugin)BuilderPlugin.getDefault(), (Throwable)ise);
        }
        return false;
    }

    protected boolean isOnJavaBuildPath(IResource resource) {
        return this.getJavaProject().isOnClasspath(resource);
    }

    public static boolean isOnClasspath(IClasspathEntry entry, IPath pathToTest, boolean isFolder) {
        IPath entryPath = entry.getPath();
        if (entryPath.equals((Object)pathToTest)) {
            return true;
        }
        return entryPath.isPrefixOf(pathToTest) && !Util.isExcluded((IPath)pathToTest, (char[][])((ClasspathEntry)entry).fullInclusionPatternChars(), (char[][])((ClasspathEntry)entry).fullExclusionPatternChars(), (boolean)isFolder);
    }

    public static boolean isOnPath(IPath path, IPath pathToTest) {
        if (path.equals((Object)pathToTest)) {
            return true;
        }
        return path.isPrefixOf(pathToTest);
    }

    public IPath getPathFromPref(String prefName, String defaultValue) {
        IPath path = null;
        String pathStr = null;
        try {
            pathStr = this.fPrefsNode.get(prefName, null);
        }
        catch (IllegalStateException ise) {
            LoggingService.logException((Plugin)BuilderPlugin.getDefault(), (Throwable)ise);
        }
        if (pathStr == null) {
            path = this.fProject != null ? this.fProject.getFullPath().append(defaultValue) : Path.fromOSString((String)defaultValue);
        } else {
            path = Path.fromOSString((String)pathStr);
            if (!path.isAbsolute() && this.fProject != null) {
                path = this.fProject.getFullPath().append(path);
            }
        }
        return path;
    }

    public void setPrefFromPath(String prefName, IPath path) throws IllegalStateException {
        if (this.fProject != null && this.fProject.getFullPath().isPrefixOf(path)) {
            this.fPrefsNode.put(prefName, path.removeFirstSegments(1).toPortableString());
        } else {
            this.fPrefsNode.put(prefName, path.toPortableString());
        }
    }

    public IContainer getContainerForPath(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFolder(path);
    }

    public IPath getDefaultOutput() {
        return this.getPathFromPref(DEFAULT_OUTPUT_PREF, this.getOutputDefault());
    }

    public IClasspathEntry[] getPathsInUse() throws IllegalStateException {
        List<IClasspathEntry> paths = this.getSourcePaths();
        if (this.useJavaSrcPaths()) {
            paths = this.getJavaSourcePaths();
        }
        return paths.toArray(new IClasspathEntry[0]);
    }

    public List<IClasspathEntry> getSourcePaths() throws IllegalStateException {
        if (this.sourcePathsModified) {
            this.loadSourcePaths();
        }
        return this.fSourcePaths;
    }

    public List<IClasspathEntry> getJavaSourcePaths() {
        IJavaProject javaProject = this.getJavaProject();
        ArrayList<IClasspathEntry> javaSourcePaths = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    javaSourcePaths.add(entry);
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            LoggingService.logException(BuilderPlugin.getDefault(), (Throwable)ce, BuilderPlugin.getResourceString("error-retrieving-java-classpath"));
        }
        return javaSourcePaths;
    }

    public boolean useJavaSrcPaths() throws IllegalStateException {
        return this.fPrefsNode.getBoolean(USE_JAVA_SRC_PATHS_PREF, true);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IJavaProject getJavaProject() {
        return JavaUtil.getJavaProject(this.fProject);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(SOURCE_PATHS_MODIFIED_PREF)) {
            this.sourcePathsModified = true;
        }
    }
}

