/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonToolsPlugin
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.common";
    private static CommonToolsPlugin plugin;
    private static final ILog platformLog;

    static {
        platformLog = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CommonToolsPlugin getDefault() {
        return plugin;
    }

    public static IStatus createErrorStatus(String msg) {
        return CommonToolsPlugin.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(Exception e) {
        return CommonToolsPlugin.createErrorStatus(e.getMessage(), e);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg) {
        return CommonToolsPlugin.createWarningStatus(msg, null);
    }

    public static IStatus createWarningStatus(Exception e) {
        return CommonToolsPlugin.createWarningStatus(e.getMessage(), e);
    }

    public static IStatus createWarningStatus(String msg, Exception e) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)e);
    }

    public static void log(Exception e) {
        String msg = String.valueOf(e.getMessage());
        CommonToolsPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        platformLog.log(status);
    }

    public static void logError(String message, Exception e) {
        CommonToolsPlugin.log(CommonToolsPlugin.createErrorStatus(message, e));
    }

    public static void logWarning(String message, Exception e) {
        CommonToolsPlugin.log(CommonToolsPlugin.createWarningStatus(message, e));
    }
}

