/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PomTemplateContextUtil {
    private static final Logger log = LoggerFactory.getLogger(PomTemplateContextUtil.class);
    public static final PomTemplateContextUtil INSTANCE = new PomTemplateContextUtil();
    private final Map<String, PluginDescriptor> descriptors = new HashMap<String, PluginDescriptor>();

    PomTemplateContextUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginDescriptor getPluginDescriptor(String groupId, String artifactId, String version) {
        String name = String.valueOf(groupId) + ":" + artifactId + ":" + version;
        PluginDescriptor descriptor = this.descriptors.get(name);
        if (descriptor != null) {
            return descriptor;
        }
        try {
            ZipFile zf;
            InputStream is;
            block17: {
                IMaven embedder = MavenPlugin.getMaven();
                List repositories = embedder.getArtifactRepositories();
                Artifact artifact = embedder.resolve(groupId, artifactId, version, "maven-plugin", null, repositories, null);
                File file = artifact.getFile();
                if (file == null) {
                    String msg = "Can't resolve plugin " + name;
                    log.error(msg);
                    return null;
                }
                is = null;
                zf = null;
                zf = new ZipFile(file);
                ZipEntry entry = zf.getEntry("META-INF/maven/plugin.xml");
                if (entry == null) break block17;
                is = zf.getInputStream(entry);
                PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
                descriptor = builder.build((Reader)new InputStreamReader(is));
                this.descriptors.put(name, descriptor);
                PluginDescriptor pluginDescriptor = descriptor;
                IOUtil.close((InputStream)is);
                try {
                    zf.close();
                    return pluginDescriptor;
                }
                catch (IOException iOException) {}
                return pluginDescriptor;
                catch (Exception ex) {
                    try {
                        String msg = "Can't read configuration for " + name;
                        log.error(msg, (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(is);
                        try {
                            zf.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    IOUtil.close((InputStream)is);
                    try {
                        zf.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            }
            IOUtil.close(is);
            try {
                zf.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (CoreException ex) {
            IStatus status = ex.getStatus();
            String msg = status.getMessage();
            if (status.getException() != null) {
                msg = String.valueOf(msg) + "; " + status.getException().getMessage();
            }
            log.error(msg, (Throwable)ex);
        }
        return null;
    }
}

