/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.tagsupport.converter.operations;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jstl.JSTLPlugin;
import oracle.eclipse.tools.webtier.jstl.tagsupport.converter.operations.AbstractJSTLTransformOperation;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Element;

public class AppendTagNameAndAttrAsChildTextOperation
extends AbstractJSTLTransformOperation {
    protected static final String USE_PARENS_FALSE_PARAM = "false";

    public Element transform(Element srcElem, Element curElem) {
        String attrValue;
        if (this.getParameters().length < 1) {
            String message = "Too few parameters specified in metadata for operation " + this.getTransformOperationID();
            LoggingService.logError((String)JSTLPlugin.getPluginId(), (String)message);
            return null;
        }
        String attrName = null;
        attrName = this.getParameters()[0];
        Assert.isNotNull((Object)attrName);
        boolean useParens = true;
        if (this.getParameters().length > 1) {
            String parensParam = this.getParameters()[1];
            Assert.isNotNull((Object)parensParam);
            if (USE_PARENS_FALSE_PARAM.equals(parensParam)) {
                useParens = false;
            }
        }
        StringBuffer sb = new StringBuffer(srcElem.getTagName());
        sb.append("  ");
        if (attrName != null && attrName.length() > 0 && (attrValue = srcElem.getAttribute(attrName)) != null && attrValue.length() > 0) {
            if (useParens) {
                sb.append("(");
            }
            sb.append(attrValue);
            if (useParens) {
                sb.append(")");
            }
        }
        this.appendChildText(sb.toString(), curElem);
        return curElem;
    }
}

