/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.tagsupport;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTaglibContextResolver;
import oracle.eclipse.tools.webtier.jstl.tagsupport.TLDConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSTLSymbolFactory
extends AbstractContextSymbolFactory {
    private static final Pattern IMMEDIATE_EL_PATTERN = Pattern.compile("([\\$\\#])\\{(.*)\\}");
    private final JSFSymbolFactory _factory = new JSFSymbolFactory();

    private ISymbol handleSymbolCreation(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement, List<?> problems) {
        IMergedModelNode mmNode;
        ITaglibContextResolver resolver = null;
        if (owningElement instanceof IDOMElement && (mmNode = (IMergedModelNode)((IDOMElement)owningElement).getAdapterFor(IMergedModelNode.class)) != null) {
            resolver = new MergedTaglibContextResolver(context);
        }
        if (resolver == null) {
            resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        }
        if (resolver == null || !resolver.canResolveContext((IModelContext)context)) {
            return null;
        }
        String uri = resolver.getTagURIForNodeName((Node)owningElement);
        ISymbol symbol = null;
        TLDConstants.TAGLIB taglib = TLDConstants.TAGLIB.forString(uri);
        if (taglib != null) {
            switch (taglib) {
                case CORE: {
                    symbol = this.handleCoreTags(symbolName, context, attr, owningElement, problems);
                    break;
                }
                default: {
                    symbol = this.getDefaultSymbol(symbolName);
                }
            }
        }
        return symbol;
    }

    private ISymbol getDefaultSymbol(String symbolName) {
        IComponentSymbol cSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        cSymbol.setName(symbolName);
        cSymbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        IComponentSymbol symbol = cSymbol;
        return symbol;
    }

    public boolean supports(IAdaptable context) {
        return context != null && context.getAdapter(IStructuredDocumentContext.class) != null && this.getJavaProject(context) != null;
    }

    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems, IAdditionalContextSymbolInfo additionalInfo) {
        IComponentSymbol symbol = null;
        if (additionalInfo != null) {
            String signature;
            Attr attr;
            Element owningElement;
            Node curNode;
            IStructuredDocumentContext sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class);
            IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(sContext);
            if (domResolver != null && (curNode = domResolver.getNode()) instanceof Attr && (owningElement = (attr = (Attr)curNode).getOwnerElement()) != null && owningElement.getNodeType() == 1) {
                symbol = this.handleSymbolCreation(symbolName, sContext, attr, owningElement, problems);
            }
            if (symbol == null && (signature = additionalInfo.getSymbolTypeSignature()) != null) {
                IJavaTypeDescriptor2 descriptor = this._factory.createTypeDescriptorFromSignature(signature, this.getJavaProject(context));
                symbol = this._factory.createJavaComponentSymbol(symbolName, descriptor, null);
            }
        }
        return symbol;
    }

    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems) {
        return null;
    }

    private IJavaProject getJavaProject(IAdaptable context) {
        IProject project;
        IStructuredDocumentContext sContext;
        if (context != null && (sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class)) != null && (project = FileContextUtil.getProject((IStructuredDocumentContext)((IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class)))) != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    private ISymbol handleCoreTags(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement, List problems) {
        ISymbol symbol = null;
        if (owningElement.getLocalName().equals("forEach")) {
            if ("var".equals(attr.getLocalName())) {
                symbol = this.handleCoreForEachTag(symbolName, context, attr, owningElement, problems);
            }
        } else if (owningElement.getLocalName().equals("set")) {
            symbol = this.handleCoreSetTag(symbolName, context, attr, owningElement, problems);
        }
        if (symbol == null) {
            symbol = this.getDefaultSymbol(symbolName);
        }
        return symbol;
    }

    private ISymbol handleCoreSetTag(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement, List problems) {
        return this.createSymbol(symbolName, context, "value", owningElement);
    }

    private ISymbol handleCoreForEachTag(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement, List problems) {
        IComponentSymbol symbol = this.createSymbol(symbolName, context, "items", owningElement);
        if (symbol != null) {
            return symbol;
        }
        return this._factory.createUnknownComponentSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
    }

    private IComponentSymbol createSymbol(String name, IStructuredDocumentContext sContext, String valueAttrName, Element element) {
        ValueType valueExpr;
        IStructuredDocumentContext elContext;
        IFile file;
        String elText;
        Expression el;
        String value;
        Attr attr;
        if (element instanceof IDOMElement && (attr = element.getAttributeNode(valueAttrName)) instanceof IDOMAttr && (value = attr.getValue()) != null && (el = JSTLSymbolFactory.extractELExpression(value)) != null && (elText = el.expression) != null && (file = FileContextUtil.deriveIFileFromContext((IAdaptable)sContext)) != null && (elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(sContext.getStructuredDocument(), ((IDOMAttr)attr).getValueRegionStartOffset() + value.indexOf(el.delim) + 1)) != null && (valueExpr = this._factory.getValueTypeFromEL(elText, elContext, file)) != null) {
            IJavaProject javaProject = this.getJavaProject((IAdaptable)sContext);
            if (Signature.getArrayCount((String)valueExpr.getSignature()) > 0) {
                return (IComponentSymbol)this._factory.createArraySymbol(name, valueExpr.getSignature(), ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, javaProject);
            }
            if (valueExpr.isInstanceOf("Ljava.util.List;")) {
                return (IComponentSymbol)this._factory.createFromList(name, valueExpr, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null, javaProject);
            }
            if (valueExpr.isInstanceOf("Ljava.lang.Object;")) {
                return this._factory.createJavaComponentSymbol(name, valueExpr, null, javaProject);
            }
        }
        return null;
    }

    private static Expression extractELExpression(String textContent) {
        Matcher matcher = IMMEDIATE_EL_PATTERN.matcher(textContent.trim());
        if (matcher.matches()) {
            String delim = matcher.group(1);
            String elText = matcher.group(2).trim();
            if (delim == null || delim.length() != 1 || "".equals(elText) || elText == null) {
                return null;
            }
            return new Expression(elText, delim.charAt(0));
        }
        return null;
    }

    private static class Expression {
        private final String expression;
        private final char delim;

        Expression(String expression, char delim) {
            this.expression = expression;
            this.delim = delim;
        }
    }
}

