/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.locale;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.LocalizationRangeStore;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.BundleReferenceCollector;
import oracle.eclipse.tools.webtier.jsp.collection.JSPResourceBundleReferenceCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class JstlResourceReferenceCollector
extends BundleReferenceCollector {
    public JstlResourceReferenceCollector() {
        super("JSTL-BUNDLE", JSPResourceBundleReferenceCollector.JSP_CONTENT_TYPES);
    }

    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        Set ranges;
        LocalizationRangeStore bundleRanges;
        ITechnologyExtension techExt;
        IDocumentLocalizationContextWorkingCopy context;
        IDocument doc;
        IFile file;
        ResourceArtifact artifact;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (resourceContext.getResource().getType() == 1 && (artifact = this.structuredContext.ensureResourceArtifact((IResource)(file = (IFile)resourceContext.getResource()))) != null && (doc = (IDocument)file.getAdapter(IDocument.class)) != null && (context = (IDocumentLocalizationContextWorkingCopy)(techExt = doc.getProject().getTechnologyExtensionById("jstl")).getDocumentService(IDocumentLocalizationContextWorkingCopy.class, doc)) != null && (bundleRanges = context.getBundleRangeStore()) != null && (ranges = bundleRanges.getRanges()) != null) {
            for (LocalizationRangeStore.RangeKeyedValue range : ranges) {
                IResource resource = this.resolveBundleResource(doc, file.getProject(), ((String)range.getValue()).trim(), range.getRange().getOffset());
                if (resource == null) continue;
                ResourceLocation location = new ResourceLocation((IResource)file, range.getDefinitionRange());
                ResourceReference reference = new ResourceReference((IArtifact)artifact, location, resource, this.getID());
                this.structuredContext.addReferencedArtifact((IArtifact)artifact, (IArtifactReference)reference, true, (byte)0);
            }
        }
    }

    private IResource resolveBundleResource(IDocument doc, IProject prjt, String baseName, long offset) {
        Project project = (Project)prjt.getAdapter(Project.class);
        IDocumentLocalizationContext context = (IDocumentLocalizationContext)doc.getAdapter(IDocumentLocalizationContext.class);
        if (context != null && project != null) {
            IBundleResource bundleResource;
            Locale currentLocale = ((IDesignTimeLocaleService)project.getAppService(IDesignTimeLocaleService.class)).getCurrentLocale();
            ArrayList<Locale> preferredLocales = new ArrayList<Locale>();
            preferredLocales.add(currentLocale);
            Locale locale = context.resolveLocale((int)offset, preferredLocales);
            if (baseName != null && locale != null && (bundleResource = context.resolveBundle((int)offset, baseName, locale)) != null) {
                return bundleResource.getUnderlyingResource();
            }
        }
        return null;
    }
}

