/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.locale;

import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jstl.TraceOptions;
import oracle.eclipse.tools.webtier.jstl.tagsupport.TLDConstants;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.AbstractAttributeValueResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JstlAttributeValueResolver
extends AbstractAttributeValueResolver {
    private static final Pattern RESOURCE_STRING = Pattern.compile("\\?\\?(.*)\\?\\?");
    private final DOMUtil _domUtil = new DOMUtil();

    public boolean canResolve(Element originalElement, Element convertedElement, String convertedAttrName, String convertedAttrValue) {
        String uri;
        IDocument document = this.getDocument(originalElement);
        if (document != null && TLDConstants.TAGLIB.isFormatTag(uri = this._domUtil.getNamespaceAtContext(document, (Node)originalElement)) && "message".equals(originalElement.getLocalName())) {
            if (TraceOptions.JSTL_ATTRIBUTE_VALUE_RESOLVER) {
                System.out.printf("canResolve for originalElement=%s, convertElement=%s,convertedAttrName=%s, convertedAttrValue=%s\n", originalElement.toString(), convertedElement.toString(), convertedAttrName.toString(), convertedAttrValue.toString());
            }
            return true;
        }
        return false;
    }

    public String resolveAttribute(Element originalElement, Element convertedElement, String convertedAttrName, String convertedAttrValue) {
        String key;
        if (!"#text".equals(convertedAttrName)) {
            throw new IllegalArgumentException("should only be called for the text content of a message");
        }
        Matcher matcher = RESOURCE_STRING.matcher(convertedAttrValue);
        if (matcher.matches() && (key = matcher.group(1).trim()) != null) {
            IDocumentLocalizationContext context = null;
            IDocument doc = this.getDocument(originalElement);
            context = (IDocumentLocalizationContext)doc.getAdapter(IDocumentLocalizationContext.class);
            if (context != null) {
                IBundleResource bundleRes;
                int startOffset = ((IDOMElement)originalElement).getFirstStructuredDocumentRegion().getStartOffset();
                String baseName = context.getImplicitBundleName(startOffset);
                IDesignTimeLocaleService localeSvc = (IDesignTimeLocaleService)doc.getProject().getAppService(IDesignTimeLocaleService.class);
                Locale preferredLocale = Locale.getDefault();
                if (localeSvc != null && (preferredLocale = localeSvc.getCurrentLocale()) == null) {
                    preferredLocale = Locale.getDefault();
                }
                Locale locale = context.resolveLocale(startOffset, Collections.singletonList(preferredLocale));
                if (baseName != null && locale != null && (bundleRes = context.resolveBundle(startOffset, baseName, locale)) != null) {
                    try {
                        ResourceBundle resBundle = bundleRes.loadBundle();
                        if (resBundle != null) {
                            String resolvedValue = resBundle.getString(key);
                            if (TraceOptions.JSTL_ATTRIBUTE_VALUE_RESOLVER) {
                                System.out.printf("Resolving value for for originalElement=%s, convertElement=%s,convertedAttrName=%s, convertedAttrValue=%s\n", originalElement.toString(), convertedElement.toString(), convertedAttrName.toString(), convertedAttrValue.toString());
                                System.out.println("\t\tValue=" + resolvedValue);
                            }
                            return resolvedValue;
                        }
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
            }
        }
        return null;
    }

    private IDocument getDocument(Element originalElement) {
        IDocument document = this._domUtil.getDocumentForNode((Node)originalElement);
        return document;
    }
}

