/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl;

import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CompoundOperationExecutor;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtils;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JstlFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)360);
        try {
            FacetUtil.uninstallLibraries((LibraryFacetUninstallConfig)((LibraryFacetUninstallConfig)config), (IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            this.updateWebXml(project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(OperationUtil.getWebContentFolderName((IProject)project)) + "/index.jsp"));
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(OperationUtil.getSrcFolderName((IProject)project)) + "/resources/application.properties"));
            CompoundOperationExecutor.executeWithPrompt((IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120), (ICompoundOperation)compoundOperation);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void updateWebXml(IProject project, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
        try {
            IDOMModel model = WebXmlUtils.getWebXmlModelForEdit((IProject)project);
            model.aboutToChangeModel();
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"context-param", (String)"param-name", (String)"javax.servlet.jsp.jstl.fmt.localizationContext");
            WebXmlUtils.saveWebXmlModel((IDOMModel)model);
            model.changedModel();
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    static final class Strings
    extends NLS {
        public static String compoundOperationTitle;

        static {
            Strings.initializeMessages((String)JstlFacetUninstallDelegate.class.getName(), Strings.class);
        }

        Strings() {
        }
    }
}

