/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IExpectedFacetService;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.IVersionProvider;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.internal.IVersionFactory;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IPreferredTagLibraryHandler;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.model.internal.ITechnologyDiscoveryStore;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.TechnologyDocumentServiceAdapterFactory;
import oracle.eclipse.tools.common.services.project.technology.TechnologyToFacetMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.webapp.Localizer;
import oracle.eclipse.tools.webtier.javawebapp.document.LocalizationSerializer;
import oracle.eclipse.tools.webtier.jstl.JSTLPlugin;
import oracle.eclipse.tools.webtier.jstl.document.OutTagFieldGenerator;
import oracle.eclipse.tools.webtier.jstl.locale.JstlAppLocalizer;
import oracle.eclipse.tools.webtier.jstl.locale.JstlDocumentLocalizationService;
import oracle.eclipse.tools.webtier.jstl.locale.JstlLocalizer;
import oracle.eclipse.tools.webtier.jstl.tagsupport.TLDConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSTLTechnologyExtension
extends AbstractTechnologyExtension
implements ITechnologyDiscoveryStore,
IPreferredTagLibraryHandler {
    public static final String ID = "jstl";
    private final TechnologyToFacetMap _techToFacetMap;
    private final IAppLocalizer _appLocalizer;

    public JSTLTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        super(project, techDescriptor);
        this._techToFacetMap = new TechnologyToFacetMap(project.getEclipseProject(), this.getTechExtDescriptor().getDiscovererInstance().getTechnologyDiscoveryProvider());
        this._appLocalizer = new JstlAppLocalizer(techDescriptor.getTechnologyIdentifier(), (Localizer)new JstlLocalizer(this.getProject()));
    }

    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        if (serviceType == IPreferredTagLibraryHandler.class) {
            return (T)((Object)this);
        }
        if (serviceType == IExpectedFacetService.class) {
            return (T)new IExpectedFacetService(){

                public Set<IProjectFacetVersion> getExpectedFacetVersion() {
                    return JSTLTechnologyExtension.this._techToFacetMap.getExpectedFacets(JSTLTechnologyExtension.this.getTechExtDescriptor().getTechnologyIdentifier());
                }

                public boolean hasCorrectFacets() {
                    Set<IProjectFacetVersion> expectedFacets = this.getExpectedFacetVersion();
                    boolean hasFacets = true;
                    for (IProjectFacetVersion expectedFacet : expectedFacets) {
                        try {
                            hasFacets &= FacetedProjectFramework.hasProjectFacet((IProject)JSTLTechnologyExtension.this.getProject().getEclipseProject(), (String)expectedFacet.getProjectFacet().getId(), (String)expectedFacet.getVersionString());
                        }
                        catch (CoreException e) {
                            LoggingService.logException((Plugin)JSTLPlugin.getDefault(), (CoreException)e);
                            hasFacets = false;
                        }
                    }
                    return hasFacets;
                }
            };
        }
        if (serviceType == IAppLocalizer.class) {
            return (T)this._appLocalizer;
        }
        if (serviceType == ITechnologyDiscoveryStore.class) {
            return (T)((Object)this);
        }
        if (serviceType == oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class) {
            return (T)new oracle.eclipse.tools.application.common.services.appservices.IVersionProvider(){

                public IVersion getVersion(String uri) {
                    if (TLDConstants.TAGLIB.CORE_v10.getUri().equals(uri) || TLDConstants.TAGLIB.FORMAT_v10.getUri().equals(uri) || TLDConstants.TAGLIB.SQL_v10.getUri().equals(uri) || TLDConstants.TAGLIB.XML_v10.getUri().equals(uri) || TLDConstants.TAGLIB.FUNCTIONS_v10.getUri().equals(uri)) {
                        return this.getVersionFactory().getVersion("1.0");
                    }
                    if (TLDConstants.TAGLIB.getAllUris().contains(uri)) {
                        return this.getVersionFactory().getVersion(JSTLTechnologyExtension.this.getVersion());
                    }
                    return null;
                }

                private IVersionFactory getVersionFactory() {
                    return Activator.getDefault().getVersionFactory();
                }
            };
        }
        return null;
    }

    public IDocumentService getDocumentService(Class<? extends IDocumentService> serviceType, final IDocument forDocument) {
        if (IDocumentContentProvider.class.equals(serviceType)) {
            return new DocumentContentProviderForJSTL(forDocument);
        }
        if (IVersionProvider.class.equals(serviceType)) {
            return new IVersionProvider(){

                public IDocument getDocument() {
                    return forDocument;
                }

                public IVersion getVersion(String nsId) {
                    return JSTLTechnologyExtension.this.getAppService(oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class).getVersion(nsId);
                }
            };
        }
        return super.getDocumentService(serviceType, forDocument);
    }

    protected TechnologyDocumentServiceAdapterFactory getServiceAdapterFactory() {
        return new TechnologyDocumentServiceAdapterFactory(){

            protected IDocumentService doCreateAdapter(Class<? extends IDocumentService> adapterType, IDocument document) {
                if (adapterType == IDocumentLocalizationContext.class || adapterType == IDocumentLocalizationContextWorkingCopy.class) {
                    return new JstlDocumentLocalizationService(document, JSTLTechnologyExtension.this.getTechExtDescriptor().getTechnologyIdentifier(), JSTLTechnologyExtension.this.getAppService(IAppLocalizer.class));
                }
                return null;
            }

            public HashingComparator getHashingComparator(Class<? extends IDocumentService> adapterType) {
                return new HashingComparator(){

                    public boolean equals(Object obj, Object obj2) {
                        if (obj instanceof Class && obj2 instanceof Class && IDocumentLocalizationContext.class.isAssignableFrom((Class)obj) && IDocumentLocalizationContext.class.isAssignableFrom((Class)obj2)) {
                            return true;
                        }
                        return super.equals(obj, obj2);
                    }

                    public int hashCode(Class<?> adapterType) {
                        if (IDocumentLocalizationContext.class.isAssignableFrom(adapterType)) {
                            return IDocumentLocalizationContext.class.hashCode();
                        }
                        return super.hashCode(adapterType);
                    }
                };
            }
        };
    }

    public void close() {
        super.close();
        this._appLocalizer.dispose();
    }

    public IPreferredTagLibraryHandler.Preference handleTagLibrary(String uri) {
        if (this.getTechnologyVersion().equals("1.1") || this.getTechnologyVersion().equals("1.2")) {
            if (TLDConstants.TAGLIB.CORE.getUri().equals(uri) || TLDConstants.TAGLIB.FORMAT.getUri().equals(uri) || TLDConstants.TAGLIB.SQL.getUri().equals(uri) || TLDConstants.TAGLIB.XML.getUri().equals(uri)) {
                return IPreferredTagLibraryHandler.Preference.PREFERRED;
            }
            if (TLDConstants.TAGLIB.CORE_v10.getUri().equals(uri) || TLDConstants.TAGLIB.FORMAT_v10.getUri().equals(uri) || TLDConstants.TAGLIB.SQL_v10.getUri().equals(uri) || TLDConstants.TAGLIB.XML_v10.getUri().equals(uri) || this.isRuntimeTagLib(uri)) {
                return IPreferredTagLibraryHandler.Preference.NOT_PREFERRED;
            }
        } else if (this.getTechnologyVersion().equals("1.0")) {
            if (TLDConstants.TAGLIB.CORE_v10.getUri().equals(uri) || TLDConstants.TAGLIB.FORMAT_v10.getUri().equals(uri) || TLDConstants.TAGLIB.SQL_v10.getUri().equals(uri) || TLDConstants.TAGLIB.XML_v10.getUri().equals(uri)) {
                return IPreferredTagLibraryHandler.Preference.PREFERRED;
            }
            if (TLDConstants.TAGLIB.CORE.getUri().equals(uri) || TLDConstants.TAGLIB.FORMAT.getUri().equals(uri) || TLDConstants.TAGLIB.SQL.getUri().equals(uri) || TLDConstants.TAGLIB.XML.getUri().equals(uri) || this.isRuntimeTagLib(uri)) {
                return IPreferredTagLibraryHandler.Preference.NOT_PREFERRED;
            }
        }
        return IPreferredTagLibraryHandler.Preference.NOT_HANDLED;
    }

    private boolean isRuntimeTagLib(String uri) {
        return TLDConstants.TAGLIB.CORE_v10_RT.getUri().equals(uri) || TLDConstants.TAGLIB.FORMAT_v10_RT.getUri().equals(uri) || TLDConstants.TAGLIB.SQL_v10_RT.getUri().equals(uri) || TLDConstants.TAGLIB.XML_v10_RT.getUri().equals(uri);
    }

    public TLDConstants.TAGLIB getCoreTagLib() {
        if (this.getTechnologyVersion().equals("1.1") || this.getTechnologyVersion().equals("1.2")) {
            return TLDConstants.TAGLIB.CORE;
        }
        return TLDConstants.TAGLIB.CORE_v10;
    }

    public IStatus load(int saveNumber) {
        LocalizationSerializer ls = new LocalizationSerializer(this.getProject().getEclipseProject(), (ITechnologyExtension)this);
        return ls.load(saveNumber);
    }

    public IStatus store(int saveNumber, int prevSaveNumber) {
        LocalizationSerializer ls = new LocalizationSerializer(this.getProject().getEclipseProject(), (ITechnologyExtension)this);
        return ls.store(this.getCachedAdapters(IDocumentLocalizationContext.class), saveNumber, prevSaveNumber);
    }

    private class DocumentContentProviderForJSTL
    extends AbstractDocumentService
    implements IDocumentContentProvider {
        public int getPriority() {
            return 5;
        }

        public DocumentContentProviderForJSTL(IDocument doc) {
            super(doc);
        }

        public List<EnumVarGenerator> getEnumVarGenerators(ValueReference valRef) {
            ArrayList<EnumVarGenerator> results = new ArrayList<EnumVarGenerator>();
            return results;
        }

        public List<FieldsGenerator> getFieldGenerators(ValueReference valRef) {
            Variable var = valRef.getVariable();
            if (var.getResolutionType() == ResolutionTime.PAGE_RUN) {
                return Collections.emptyList();
            }
            ArrayList<FieldsGenerator> results = new ArrayList<FieldsGenerator>();
            FilePositionContext modelContext = new FilePositionContext(this.getDocument().getFile());
            if (valRef.getType((IModelContext)modelContext).getNumFields((IModelContext)modelContext) <= 1) {
                results.add(new OutTagFieldGenerator(this.getDocument()));
            }
            return results;
        }
    }
}

