/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.DefaultTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;

public abstract class AbstractJSTLTechnologyDiscoverer
extends DefaultTechnologyDiscoverer {
    private final List<String> _expectedClass;
    private final List<String> _expectedNotPresentClasses;

    public AbstractJSTLTechnologyDiscoverer(List<String> expectedClasses, List<String> expectedNotPresentClasses, AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
        super(technologyDiscoveryProvider, techId);
        this._expectedClass = expectedClasses;
        this._expectedNotPresentClasses = expectedNotPresentClasses;
    }

    public boolean isActive() {
        Project project;
        IAppClassLoaderProvider appService;
        boolean isActive = super.isActive();
        if (!isActive && (appService = (IAppClassLoaderProvider)(project = this.getTechnologyDiscoveryProvider().getProject()).getAppService(IAppClassLoaderProvider.class)) != null) {
            boolean allClassesFound = true;
            for (String className : this._expectedClass) {
                allClassesFound &= appService.hasClass(className);
            }
            boolean allClassesNotFound = true;
            for (String className : this._expectedNotPresentClasses) {
                allClassesNotFound &= !appService.hasClass(className);
            }
            isActive = allClassesFound && allClassesNotFound;
        }
        return isActive;
    }

    public static class JSTL11TechnologyDiscoverer
    extends AbstractJSTLTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES = Collections.singletonList("javax.servlet.jsp.jstl.core.Config");
        private static final List<String> EXPECTED_NOT_FOUND_CLASSES = Collections.singletonList("javax.servlet.jsp.jstl.core.IndexedValueExpression");

        public JSTL11TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES, EXPECTED_NOT_FOUND_CLASSES, technologyDiscoveryProvider, techId);
        }
    }

    public static class JSTL12TechnologyDiscoverer
    extends AbstractJSTLTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES_12;

        static {
            ArrayList<String> initExpectedClasses = new ArrayList<String>();
            initExpectedClasses.addAll(JSTL11TechnologyDiscoverer.EXPECTED_CLASSES);
            initExpectedClasses.add("javax.servlet.jsp.jstl.core.IndexedValueExpression");
            EXPECTED_CLASSES_12 = Collections.unmodifiableList(initExpectedClasses);
        }

        public JSTL12TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES_12, Collections.EMPTY_LIST, technologyDiscoveryProvider, techId);
        }
    }
}

