/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

class P2Utils {
    static /* synthetic */ Class class$0;

    P2Utils() {
    }

    public static BundleInfo findBundle(String symbolicName, Version version, boolean isSourceBundle) {
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((version != null ? 1 : 0) != 0);
        return P2Utils.findBundle(symbolicName, new VersionRange(version, true, version, true), isSourceBundle);
    }

    public static BundleInfo findBundle(String symbolicName, VersionRange versionRange, boolean isSourceBundle) {
        SimpleConfiguratorManipulator manipulator;
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((versionRange != null ? 1 : 0) != 0);
        JUnitCorePlugin jUnitCorePlugin = JUnitCorePlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manipulator = (SimpleConfiguratorManipulator)jUnitCorePlugin.getService(clazz.getName())) == null) {
            return null;
        }
        BundleInfo bestMatch = null;
        Version bestVersion = null;
        String bundleInfoPath = null;
        if (isSourceBundle) {
            bundleInfoPath = SimpleConfiguratorManipulator.SOURCE_INFO;
        }
        BundleContext context = JUnitCorePlugin.getDefault().getBundle().getBundleContext();
        BundleInfo[] bundles = null;
        try {
            bundles = manipulator.loadConfiguration(context, bundleInfoPath);
        }
        catch (IOException e) {
            JUnitCorePlugin.log(e);
        }
        if (bundles != null) {
            int j = 0;
            while (j < bundles.length) {
                IPath path;
                Version version;
                BundleInfo bundleInfo = bundles[j];
                if (symbolicName.equals(bundleInfo.getSymbolicName()) && versionRange.isIncluded(version = new Version(bundleInfo.getVersion())) && (path = P2Utils.getBundleLocationPath(bundleInfo)).toFile().exists() && (bestMatch == null || bestVersion.compareTo(version) < 0)) {
                    bestMatch = bundleInfo;
                    bestVersion = version;
                }
                ++j;
            }
        }
        return bestMatch;
    }

    public static IPath getBundleLocationPath(BundleInfo bundleInfo) {
        if (bundleInfo == null) {
            return null;
        }
        URI bundleLocation = bundleInfo.getLocation();
        if (bundleLocation == null) {
            return null;
        }
        try {
            URL localFileURL = FileLocator.toFileURL((URL)URIUtil.toURL((URI)bundleLocation));
            URI localFileURI = new URI(localFileURL.toExternalForm());
            return new Path(localFileURI.getPath());
        }
        catch (IOException e) {
            JUnitCorePlugin.log(e);
            return null;
        }
        catch (URISyntaxException e) {
            JUnitCorePlugin.log(e);
            return null;
        }
    }
}

