/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.override.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;

public class SizeLimitContributor
extends PropertyEditorAssistContributor {
    private static final String SIZE_VALIDATOR = "oracle.eclipse.tools.coherence.descriptors.internal.SizeValidator";

    public void contribute(PropertyEditorAssistContext context) {
        Service service;
        Element element = context.getPart().getLocalModelElement();
        PropertyDef property = ((PropertyEditorPart)context.getPart()).property().definition();
        if (property instanceof ValueProperty && element.property((ValueProperty)property).text(false) != null && (service = this.findSizeValidatorService(property)) != null) {
            String min = null;
            String max = null;
            Service.Param[] paramArray = service.params();
            int n = paramArray.length;
            int n2 = 0;
            while (n2 < n) {
                Service.Param param = paramArray[n2];
                if (param.name().equals("min")) {
                    min = param.value();
                } else if (param.name().equals("max")) {
                    max = param.value();
                }
                ++n2;
            }
            String description = null;
            if (min != null && min.length() > 0 && max != null && max.length() > 0) {
                description = NLS.bind((String)Resources.between, (Object)min, (Object)max);
            } else if (min != null && min.length() > 0) {
                description = NLS.bind((String)Resources.minimum, (Object)min);
            } else if (max != null && max.length() > 0) {
                description = NLS.bind((String)Resources.maximum, (Object)max);
            }
            if (description != null) {
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p>" + description + "</p>");
                PropertyEditorAssistSection section = context.getSection("info");
                section.addContribution(contribution.create());
            }
        }
    }

    private Service findSizeValidatorService(PropertyDef property) {
        Service serviceAnnotation = (Service)property.getAnnotation(Service.class);
        if (serviceAnnotation != null && SIZE_VALIDATOR.equals(serviceAnnotation.impl().getName())) {
            return serviceAnnotation;
        }
        Services servicesAnnotation = (Services)property.getAnnotation(Services.class);
        if (servicesAnnotation != null) {
            Service[] serviceArray = servicesAnnotation.value();
            int n = serviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Service svc = serviceArray[n2];
                if (SIZE_VALIDATOR.equals(svc.impl().getName())) {
                    return svc;
                }
                ++n2;
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String between;
        public static String minimum;
        public static String maximum;

        static {
            Resources.initializeMessages((String)SizeLimitContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

