/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.launchConfig;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.CoherenceException;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ILaunchConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigResource;
import oracle.eclipse.tools.coherence.facets.CoherenceFacet;
import oracle.eclipse.tools.coherence.launchConfig.CoherenceLaunchConfigurationDelegate;
import oracle.eclipse.tools.coherence.ui.internal.CoherenceUiPlugin;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CoherenceLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private CoherenceLaunchConfigurationTab mainTab;

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs;
        this.mainTab = new CoherenceLaunchConfigurationTab();
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = new ILaunchConfigurationTab[]{new JavaMainTab(), this.mainTab, new JavaArgumentsTab(), new JavaJRETab(), new JavaClasspathTab(), new SourceLookupTab(), new EnvironmentTab(), new CommonTab()};
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            tab.setLaunchConfigurationDialog(dialog);
            ++n2;
        }
        this.setTabs(tabs);
    }

    private static CoherenceLaunchConfigurationDelegate getCoherenceLaunchConfigurationDelegate(ILaunchConfiguration configuration) {
        CoherenceLaunchConfigurationDelegate coherenceDelegate = null;
        try {
            ILaunchDelegate[] delegates;
            ILaunchConfigurationType type = configuration.getType();
            HashSet<String> modes = new HashSet<String>();
            modes.add("debug");
            ILaunchDelegate[] iLaunchDelegateArray = delegates = type.getDelegates(modes);
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                if (delegate.getDelegate() instanceof CoherenceLaunchConfigurationDelegate) {
                    coherenceDelegate = (CoherenceLaunchConfigurationDelegate)delegate.getDelegate();
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return coherenceDelegate;
    }

    private static String[] concat(String[] a, String[] b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        String[] all = new String[a.length + b.length];
        System.arraycopy(a, 0, all, 0, a.length);
        System.arraycopy(b, 0, all, a.length, b.length);
        return all;
    }

    private static class CoherenceLaunchConfigurationTab
    extends AbstractLaunchConfigurationTab {
        private ILaunchConfig config;
        private Status validationState = null;
        private CoherenceModel model = new CoherenceModel(){

            public void propertyChanged() {
                CoherenceLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };

        private CoherenceLaunchConfigurationTab() {
        }

        public Image getImage() {
            ImageDescriptor desc = SwtUtil.createImageDescriptor(CoherenceUiPlugin.class, (String)"images/coherence-configuration.png");
            return desc.createImage();
        }

        public void createControl(Composite parent) {
            LaunchConfigResource res = new LaunchConfigResource(this.model);
            this.config = (ILaunchConfig)ILaunchConfig.TYPE.instantiate((Resource)res);
            Composite topTabControl = new Composite(parent, 0);
            topTabControl.setLayout((Layout)GridLayoutUtil.glayout((int)1, (int)10, (int)10));
            final SapphireForm coherenceLaunchConfigControl = new SapphireForm(topTabControl, (Element)this.config, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("sdef.CoherenceLaunchConfig").form());
            coherenceLaunchConfigControl.setLayoutData((Object)GridLayoutUtil.gdfill());
            this.setControl((Control)topTabControl);
            final Runnable messageUpdateOperation = new Runnable(){

                @Override
                public void run() {
                    CoherenceLaunchConfigurationTab.this.validationState = coherenceLaunchConfigControl.part().validation();
                }
            };
            messageUpdateOperation.run();
            Listener messageUpdateListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof PartValidationEvent) {
                        messageUpdateOperation.run();
                    }
                }
            };
            coherenceLaunchConfigControl.part().attach(messageUpdateListener);
        }

        public String getName() {
            return Resources.coherence;
        }

        public boolean isValid(ILaunchConfiguration launchConfig) {
            boolean valid = super.isValid(launchConfig);
            if (valid) {
                block6: {
                    this.setErrorMessage(null);
                    CoherenceLaunchConfigurationDelegate delegate = CoherenceLaunchConfigurationTabGroup.getCoherenceLaunchConfigurationDelegate(launchConfig);
                    IJavaProject javaProject = delegate.getJavaProject(launchConfig);
                    if (javaProject == null) break block6;
                    IProject project = javaProject.getProject();
                    boolean hasCoherence = CoherenceFacet.isInstalled((IProject)project);
                    if (!hasCoherence) {
                        this.setErrorMessage(Resources.coherenceFacetError);
                        return false;
                    }
                }
                try {
                    this.setErrorMessage(Resources.coherenceFacetError);
                    return false;
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)CoherenceUiPlugin.getDefault(), (CoreException)e);
                }
                if (this.validationState != null && this.validationState.severity() == Status.Severity.ERROR) {
                    this.setErrorMessage(this.validationState.message());
                    return false;
                }
            }
            return true;
        }

        public void initializeFrom(ILaunchConfiguration configuration) {
            this.model.clearValues();
            try {
                Map map = configuration.getAttribute("coherence.values", null);
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        this.model.setValue((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)CoherenceUiPlugin.getDefault(), (CoreException)e);
            }
            this.model = this.parseCoherenceModel(configuration);
            this.config.refresh();
        }

        private CoherenceModel parseCoherenceModel(ILaunchConfiguration configuration) {
            this.model.clear();
            try {
                CoherenceLaunchConfigurationDelegate delegate = CoherenceLaunchConfigurationTabGroup.getCoherenceLaunchConfigurationDelegate(configuration);
                String vmArguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
                String[] classpaths = delegate.getClasspath(configuration);
                String[] bootClasspaths = delegate.getBootpath(configuration);
                this.model.setJavaProject(delegate.getJavaProject(configuration));
                this.model.setWorkingDir(delegate.getWorkingDirectory(configuration));
                this.model.parse(CoherenceLaunchConfigurationTabGroup.concat(classpaths, bootClasspaths), vmArguments);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)CoherenceUiPlugin.getDefault(), (CoreException)e);
            }
            catch (CoherenceException e) {
                LoggingService.logException((Plugin)CoherenceUiPlugin.getDefault(), (Throwable)e);
            }
            return this.model;
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            HashMap<String, String> systemPropertiesMap = new HashMap<String, String>();
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            for (String key : this.model.getKeySet()) {
                String value;
                String systemProperty = this.model.getSystemProperty(key);
                if (systemProperty != null) {
                    systemPropertiesMap.put(key, systemProperty);
                }
                if ((value = this.model.getValue(key)) == null) continue;
                valuesMap.put(key, value);
            }
            configuration.setAttribute("coherence.system.properties", systemPropertiesMap);
            configuration.setAttribute("coherence.values", valuesMap);
        }

        public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String coherence;
        public static String coherenceFacetError;

        static {
            Resources.initializeMessages((String)CoherenceLaunchConfigurationTabGroup.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

