/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.cacheConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IParamTypeName;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;

public class ParamTypeContributor
extends PropertyEditorAssistContributor {
    private final String PARAM = "Param";
    Element element;
    FilteredListener<PropertyContentEvent> listener;

    public void init(SapphirePart part) {
        super.init(part);
        this.element = part.getLocalModelElement();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ParamTypeContributor.this.broadcast();
            }
        };
        this.element.attach(this.listener, String.valueOf(((PropertyEditorPart)part).property().name()) + "Param");
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null && this.element != null) {
            this.element.detach(this.listener);
            this.listener = null;
        }
    }

    public void contribute(final PropertyEditorAssistContext context) {
        final Element element = context.getPart().getLocalModelElement();
        PropertyDef property = ((PropertyEditorPart)context.getPart()).property().definition();
        final PropertyDef paramProperty = element.type().property(String.valueOf(property.name()) + "Param");
        Element parent = element.parent().element();
        if (parent instanceof ICoherenceCacheConfig && paramProperty != null && property instanceof ValueProperty && element.property((ValueProperty)property).text(false) != null) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            final String paramName = element.property((ValueProperty)paramProperty).text(false);
            contribution.text(this.buildParamTypeText(paramName));
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    IParamTypeName paramTypeName = (IParamTypeName)IParamTypeName.TYPE.instantiate();
                    try {
                        String newName;
                        paramTypeName.setName(element.property((ValueProperty)paramProperty).text(false));
                        SapphireDialog dialog = new SapphireDialog(context.getShell(), (Element)paramTypeName, DefinitionLoader.context(this.getClass()).sdef("sdef.CoherenceCacheConfig").dialog("name"));
                        if (dialog.open() == 0 && !ObjectUtil.equals((Object)paramName, (Object)(newName = paramTypeName.getName().text(false)))) {
                            element.property((ValueProperty)paramProperty).write((Object)newName);
                        }
                    }
                    finally {
                        paramTypeName.dispose();
                    }
                }
            });
            PropertyEditorAssistSection section = context.getSection(paramName == null ? "actions" : "info");
            section.addContribution(contribution.create());
        }
    }

    private String buildParamTypeText(String paramName) {
        StringBuffer buf = new StringBuffer();
        buf.append("<p>");
        if (paramName == null) {
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(Resources.addParamType);
            buf.append("</a>");
        } else {
            buf.append(Resources.paramType);
            buf.append(" \"");
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(paramName);
            buf.append("</a>");
            buf.append("\".");
        }
        buf.append("</p>");
        return buf.toString();
    }

    private static final class Resources
    extends NLS {
        public static String paramType;
        public static String addParamType;

        static {
            Resources.initializeMessages((String)ParamTypeContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

