/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.vbundle.server;

import com.sun.jersey.api.container.httpserver.HttpServerFactory;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.net.httpserver.HttpServer;
import javax.ws.rs.core.Application;

public class JerseyHttpStarter {
    protected String launchPath;
    protected String resourceClass;
    protected HttpServer server;

    public JerseyHttpStarter(String launchPath, String resourceClass) {
        this.launchPath = launchPath;
        this.resourceClass = resourceClass;
    }

    public static void main(String[] args) {
        JerseyHttpStarter app = new JerseyHttpStarter(args[0], args[1]);
        app.run();
    }

    public void run() {
        try {
            if (this.resourceClass != null && !this.resourceClass.isEmpty()) {
                DefaultResourceConfig rc = new DefaultResourceConfig();
                Class<?> rootResource = Class.forName(this.resourceClass);
                if (Application.class.isAssignableFrom(rootResource)) {
                    Application resourceApplication = (Application)rootResource.newInstance();
                    rc.add(resourceApplication);
                } else {
                    rc.getClasses().add(rootResource);
                }
                this.server = HttpServerFactory.create((String)this.launchPath, (ResourceConfig)rc);
            } else {
                this.server = HttpServerFactory.create((String)this.launchPath);
            }
            try {
                this.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.server == null) {
                return;
            }
            System.out.println("Stop!");
            this.server.stop(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

