/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.html.ui.internal.wizard.FacetModuleCoreSupport;

final class FacetModuleCoreSupportDelegate {
    private static final String JST_WEB_MODULE = "jst.web";
    private static final String WST_WEB_MODULE = "wst.web";
    private static final String JST_WEBFRAGMENT_MODULE = "jst.webfragment";

    FacetModuleCoreSupportDelegate() {
    }

    static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists() && component.getRootFolder() != null) {
            path = component.getRootFolder().getWorkspaceRelativePath();
            if (component.getRootFolder().getFolder(FacetModuleCoreSupport.META_INF_RESOURCES_PATH).getUnderlyingFolder().isAccessible()) {
                path = path.append(FacetModuleCoreSupport.META_INF_RESOURCES_PATH);
            }
        }
        return path;
    }

    static boolean isWebProject(IProject project) {
        boolean is = false;
        try {
            IProjectFacet facet;
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (ProjectFacetsManager.isProjectFacetDefined((String)JST_WEB_MODULE)) {
                facet = ProjectFacetsManager.getProjectFacet((String)JST_WEB_MODULE);
                boolean bl = is = is || faceted != null && faceted.hasProjectFacet(facet);
            }
            if (!is && ProjectFacetsManager.isProjectFacetDefined((String)WST_WEB_MODULE)) {
                facet = ProjectFacetsManager.getProjectFacet((String)WST_WEB_MODULE);
                boolean bl = is = is || faceted != null && faceted.hasProjectFacet(facet);
            }
            if (!is && ProjectFacetsManager.isProjectFacetDefined((String)JST_WEBFRAGMENT_MODULE)) {
                facet = ProjectFacetsManager.getProjectFacet((String)JST_WEBFRAGMENT_MODULE);
                is = is || faceted != null && faceted.hasProjectFacet(facet);
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return is;
    }

    static IPath[] getAcceptableRootPaths(IProject project) {
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return new IPath[]{project.getFullPath()};
        }
        ArrayList<Object> paths = new ArrayList<Object>();
        IVirtualFolder componentFolder = ComponentCore.createFolder((IProject)project, (IPath)Path.ROOT);
        if (componentFolder != null && componentFolder.exists()) {
            IContainer[] workspaceFolders = componentFolder.getUnderlyingFolders();
            int i = 0;
            while (i < workspaceFolders.length) {
                if (workspaceFolders[i].getFolder(FacetModuleCoreSupport.META_INF_RESOURCES_PATH).isAccessible()) {
                    paths.add(workspaceFolders[i].getFullPath().append(FacetModuleCoreSupport.META_INF_RESOURCES_PATH));
                } else {
                    paths.add(workspaceFolders[i].getFullPath());
                }
                ++i;
            }
            IVirtualReference[] references = ComponentCore.createComponent((IProject)project).getReferences();
            if (references != null) {
                int i2 = 0;
                while (i2 < references.length) {
                    IPath resources;
                    IPath referencedPathRoot;
                    IVirtualFolder rootFolder;
                    IVirtualComponent component;
                    IVirtualComponent referencedComponent = references[i2].getReferencedComponent();
                    if (referencedComponent != null && (component = referencedComponent.getComponent()) != null && (rootFolder = component.getRootFolder()) != null && (referencedPathRoot = rootFolder.getWorkspaceRelativePath()) != null && (resources = referencedPathRoot.append("META-INF/resources/")) != null && component.getProject().findMember(resources.removeFirstSegments(1)) != null) {
                        paths.add(resources);
                    }
                    ++i2;
                }
            }
        } else {
            paths.add(new IPath[]{project.getFullPath()});
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    static IPath getDefaultRoot(IProject project) {
        IVirtualFolder componentFolder;
        if (ModuleCoreNature.isFlexibleProject((IProject)project) && (componentFolder = ComponentCore.createFolder((IProject)project, (IPath)Path.ROOT)) != null && componentFolder.exists()) {
            return componentFolder.getWorkspaceRelativePath();
        }
        return null;
    }

    static IPath getRootContainerForPath(IProject project, IPath path) {
        IVirtualFolder componentFolder;
        if (ModuleCoreNature.isFlexibleProject((IProject)project) && (componentFolder = ComponentCore.createFolder((IProject)project, (IPath)Path.ROOT)) != null && componentFolder.exists()) {
            IContainer[] workspaceFolders = componentFolder.getUnderlyingFolders();
            int i = 0;
            while (i < workspaceFolders.length) {
                if (workspaceFolders[i].getFullPath().isPrefixOf(path)) {
                    return workspaceFolders[i].getFullPath();
                }
                ++i;
            }
        }
        return null;
    }
}

