/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters;

import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.adapters.SimpleAdapter;
import org.python.pydev.refactoring.ast.visitors.FindDuplicatesVisitor;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;
import org.python.pydev.refactoring.ast.visitors.context.ClassDefVisitor;
import org.python.pydev.refactoring.ast.visitors.context.LocalFunctionDefVisitor;
import org.python.pydev.refactoring.ast.visitors.context.ScopeAssignedVisitor;
import org.python.pydev.refactoring.ast.visitors.context.ScopeVariablesVisitor;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeNode<T extends SimpleNode>
extends AbstractNodeAdapter<T> {
    private List<SimpleAdapter> usedVariables;
    private List<SimpleAdapter> assignedVariables;
    private List<FunctionDefAdapter> functions;
    private List<IClassDefAdapter> classes;

    protected AbstractScopeNode() {
    }

    public AbstractScopeNode(ModuleAdapter module, AbstractScopeNode<? extends SimpleNode> parent, T node, AdapterPrefs adapterPrefs) {
        super(module, parent, node, adapterPrefs);
    }

    public List<FunctionDefAdapter> getFunctions() {
        if (this.functions == null) {
            Object node = this.getASTNode();
            ModuleAdapter module = this.getModule();
            assert (node != null);
            assert (module != null);
            LocalFunctionDefVisitor visitor = VisitorFactory.createContextVisitor(LocalFunctionDefVisitor.class, node, module, this);
            this.functions = visitor.getAll();
        }
        return this.functions;
    }

    public List<IClassDefAdapter> getClasses() {
        if (this.classes == null) {
            ClassDefVisitor visitor = VisitorFactory.createContextVisitor(ClassDefVisitor.class, this.getASTNode(), this.getModule(), this);
            this.classes = visitor.getAll();
        }
        return this.classes;
    }

    public List<SimpleAdapter> getAssignedVariables() {
        if (this.assignedVariables == null) {
            ScopeAssignedVisitor visitor = VisitorFactory.createContextVisitor(ScopeAssignedVisitor.class, this.getASTNode(), this.getModule(), this);
            this.assignedVariables = visitor.getAll();
        }
        return this.assignedVariables;
    }

    public List<SimpleAdapter> getUsedVariables() {
        if (this.usedVariables == null) {
            ScopeVariablesVisitor visitor = VisitorFactory.createContextVisitor(ScopeVariablesVisitor.class, this.getASTNode(), this.getModule(), this);
            this.usedVariables = visitor.getAll();
        }
        return this.usedVariables;
    }

    public boolean alreadyUsedName(String newName) {
        for (SimpleAdapter adapter : this.getUsedVariables()) {
            if (adapter.getName().compareTo(newName) != 0) continue;
            return true;
        }
        return false;
    }

    public List<Tuple<ITextSelection, SimpleNode>> getDuplicates(ITextSelection selection, exprType expression) {
        FindDuplicatesVisitor v = VisitorFactory.createDuplicatesVisitor(selection, this.getASTNode(), expression, this, this.getModule().getDoc());
        return v.getDuplicates();
    }
}

