/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.framework.Bundle;

public class EcoreLoader {
    protected Map<String, URI> _additionalPackages = new HashMap<String, URI>();

    public void addAdditionalPackage(String packageUri, URI path) {
        this._additionalPackages.put(packageUri, path);
    }

    public void loadRes(Resource res, URI tldLocation) throws IOException {
        ExtensibleURIConverterImpl uriConvertier = res.getResourceSet().getURIConverter() != null ? res.getResourceSet().getURIConverter() : new ExtensibleURIConverterImpl();
        InputStream stream = uriConvertier.createInputStream(tldLocation);
        try {
            res.load(stream, Collections.emptyMap());
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed to close stream");
            }
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to close stream");
        }
    }

    public ResourceSet createEcoreResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
        resourceSet.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new GenericXMLResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                XMLResourceImpl result = new XMLResourceImpl(uri);
                result.setEncoding("UTF-8");
                result.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                result.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                result.getDefaultSaveOptions().put("LINE_WIDTH", 80);
                result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                result.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                result.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
                xmlOptions.setProcessAnyXML(true);
                xmlOptions.setProcessSchemaLocations(true);
                result.getDefaultLoadOptions().put("XML_OPTIONS", xmlOptions);
                return result;
            }
        });
        resourceSet.getURIConverter().getURIHandlers().add(0, (Object)new URIHandlerImpl(){

            public boolean canHandle(URI uri) {
                return uri.isPlatformPlugin() || EcoreLoader.this._additionalPackages.containsValue(uri);
            }

            public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                if (uri.isPlatform() && uri.segmentCount() > 2) {
                    Path path;
                    URL url;
                    String symbolicName = uri.segment(1);
                    Bundle bundle = Platform.getBundle((String)symbolicName);
                    if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(uri.path())).removeFirstSegments(2).makeAbsolute(), Collections.emptyMap())) != null) {
                        return url.openStream();
                    }
                    throw new IOException("Could not get input stream for uri: " + uri);
                }
                throw new IllegalStateException();
            }
        });
        return resourceSet;
    }
}

