/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.util;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public abstract class AbstractECoreUtil {
    protected abstract void generate() throws Exception;

    protected final ResourceSet createInitializedResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.initResourceSet((ResourceSet)resourceSet);
        return resourceSet;
    }

    protected final Resource getNewResource(ResourceSet resSet, URI uri) throws IOException {
        Resource res = this.createResource(resSet, uri);
        res.load(Collections.EMPTY_MAP);
        return res;
    }

    protected final Resource createResource(ResourceSet resSet, URI uri) {
        return resSet.createResource(uri);
    }

    protected final void initResourceSet(ResourceSet resourceSet) {
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
        resourceSet.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
    }

    protected static enum CmdLineError {
        NOT_ENOUGH_ARGUMENTS,
        FILE_NOT_FOUND,
        GENERAL_IO_FAILURE;


        public String toString() {
            switch (this) {
                case FILE_NOT_FOUND: {
                    return "File not found";
                }
                case NOT_ENOUGH_ARGUMENTS: {
                    return "Not enough arguments";
                }
                case GENERAL_IO_FAILURE: {
                    return "General IO failure";
                }
            }
            return "";
        }

        public int toReturnCode() {
            switch (this) {
                case FILE_NOT_FOUND: {
                    return -1;
                }
                case NOT_ENOUGH_ARGUMENTS: {
                    return -2;
                }
                case GENERAL_IO_FAILURE: {
                    return -3;
                }
            }
            return Integer.MIN_VALUE;
        }
    }
}

