/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.tagdoc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.eclipse.tools.xml.model.Activator;
import oracle.eclipse.tools.xml.model.tagdoc.BundleResourceRef;
import oracle.eclipse.tools.xml.model.tagdoc.HelpTopic;
import oracle.eclipse.tools.xml.model.tagdoc.TagDoc;
import org.eclipse.help.ITopic;

public abstract class TagDocBook {
    private boolean initialized;
    private String libraryName;
    private String libraryNamespace;
    private String libraryNamespacePrefix;
    private String libraryVersion;
    private String libraryTocTopicName;
    private String libraryDocBundle;
    private String libraryDocContextRoot;
    private final List<TagDoc> tagdocs = new ArrayList<TagDoc>();

    public final String getLibraryName() {
        return this.libraryName;
    }

    protected final void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public final String getLibraryNamespace() {
        return this.libraryNamespace;
    }

    protected final void setLibraryNamespace(String libraryNamespace) {
        this.libraryNamespace = libraryNamespace;
    }

    public final String getLibraryNamespacePrefix() {
        return this.libraryNamespacePrefix;
    }

    protected final void setLibraryNamespacePrefix(String libraryNamespacePrefix) {
        this.libraryNamespacePrefix = libraryNamespacePrefix;
    }

    public final String getLibraryVersion() {
        return this.libraryVersion;
    }

    protected final void setLibraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
    }

    public final String getLibraryTocTopicName() {
        return this.libraryTocTopicName;
    }

    protected final void setLibraryTocTopicName(String libraryTocTopicName) {
        this.libraryTocTopicName = libraryTocTopicName;
    }

    public final String getLibraryDocPlugin() {
        return this.libraryDocBundle;
    }

    protected final void setLibraryDocPlugin(String libraryDocBundle) {
        this.libraryDocBundle = libraryDocBundle;
    }

    public final String getLibraryDocContextRoot() {
        if (this.libraryDocContextRoot == null) {
            return this.getLibraryNamespacePrefix();
        }
        return this.libraryDocContextRoot;
    }

    public final void setLibraryDocContextRoot(String libraryDocContextRoot) {
        this.libraryDocContextRoot = libraryDocContextRoot;
    }

    protected final synchronized void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.initializeInternal();
        }
    }

    protected abstract void initializeInternal();

    public final List<String> getCategories() {
        this.initialize();
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        for (TagDoc tagdoc : this.tagdocs) {
            String category = tagdoc.getCategory();
            if (category == null) continue;
            categories.add(category);
        }
        return Collections.unmodifiableList(new ArrayList(categories));
    }

    public final List<TagDoc> getTagDocs(String category) {
        this.initialize();
        ArrayList<TagDoc> tagdocsList = new ArrayList<TagDoc>();
        for (TagDoc tagdoc : this.tagdocs) {
            if (!category.equalsIgnoreCase(tagdoc.getCategory())) continue;
            tagdocsList.add(tagdoc);
        }
        return Collections.unmodifiableList(tagdocsList);
    }

    protected final void addTagDoc(TagDoc tagdoc) {
        this.tagdocs.add(tagdoc);
    }

    public final TagDoc getTagDoc(String name) {
        this.initialize();
        for (TagDoc tagdoc : this.tagdocs) {
            if (!tagdoc.getName().equals(name)) continue;
            return tagdoc;
        }
        return null;
    }

    public final BundleResourceRef getContentRef(String href) {
        this.initialize();
        return new BundleResourceRef(this.getLibraryDocPlugin(), this.getLibraryDocContextRoot(), href);
    }

    public final InputStream getContent(String href) {
        this.initialize();
        InputStream in = null;
        in = href.startsWith("summary/") ? this.generateTagSummaryPage(href) : this.getContentInternal(href);
        return in;
    }

    protected abstract InputStream getContentInternal(String var1);

    public final String getTextContent(String href) {
        return TagDocBook.getTextContent(this.getContent(href));
    }

    /*
     * Loose catch block
     */
    public static final String getTextContent(InputStream in) {
        if (in != null) {
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
            StringBuilder buf = new StringBuilder();
            char[] chars = new char[1024];
            int count = reader.read(chars);
            while (count != -1) {
                buf.append(chars, 0, count);
                count = reader.read(chars);
            }
            String string = buf.toString();
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException e) {
                try {
                    Activator.log(e);
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected String getFooter() {
        return null;
    }

    protected static String getResourcesRelPath(String href) {
        int depth = 0;
        int i = 0;
        int n = href.length();
        while (i < n) {
            char ch = href.charAt(i);
            if (ch == '/' || ch == '\\') {
                ++depth;
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        while (i2 < depth) {
            buf.append("../");
            ++i2;
        }
        return buf.toString();
    }

    private InputStream generateTagSummaryPage(String href) {
        String category = href.substring("summary/".length());
        if (category.endsWith(".html")) {
            category = category.substring(0, category.length() - 5);
        }
        boolean overall = category.equals("index");
        StringBuilder buf = new StringBuilder();
        buf.append("<html>\n");
        buf.append("<head>\n");
        buf.append("<link href=\"##resources##style.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
        buf.append("</head>\n");
        buf.append("<body>\n");
        buf.append("<h1>" + this.getLibraryName() + "</h1>");
        buf.append("<p><b>Short name:</b> &nbsp;" + this.getLibraryNamespacePrefix() + "<br>\n");
        buf.append("<b>Namespace:</b> &nbsp;" + this.getLibraryNamespace() + "<br></p>\n");
        if (overall) {
            String anchor;
            buf.append("<h2>Table of Contents</h2>\n");
            buf.append("<ul>\n");
            for (String cat : this.getCategories()) {
                anchor = cat.toLowerCase().replace(' ', '_');
                buf.append("<li><a href=\"#");
                buf.append(anchor);
                buf.append("\">");
                buf.append(cat);
                buf.append("</a></li>\n");
            }
            buf.append("</ul>\n");
            for (String cat : this.getCategories()) {
                anchor = cat.toLowerCase().replace(' ', '_');
                buf.append("<h2><a name=\"");
                buf.append(anchor);
                buf.append("\">");
                buf.append(cat);
                buf.append("</a></h2>");
                this.generateTagSummaryTable(buf, this.getTagDocs(cat));
            }
        } else {
            buf.append("<h2>");
            buf.append(category);
            buf.append("</h2>");
            this.generateTagSummaryTable(buf, this.getTagDocs(category));
        }
        String footer = this.getFooter();
        if (footer != null) {
            buf.append(footer);
        }
        buf.append("</body>\n");
        buf.append("</html>\n");
        String text = buf.toString().replace("##resources##", TagDocBook.getResourcesRelPath(href));
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    private void generateTagSummaryTable(StringBuilder buf, List<TagDoc> tagdocs_) {
        boolean displaySampleImages = false;
        for (TagDoc tagdoc : tagdocs_) {
            if (tagdoc.getSampleImage() == null) continue;
            displaySampleImages = true;
            break;
        }
        buf.append("<table border=\"1\" cellspacing=\"0\">\n");
        buf.append("<tr><th>Name</th><th>Description</th>");
        if (displaySampleImages) {
            buf.append("<th>Sample Image</th>");
        }
        buf.append("</tr>\n");
        for (TagDoc tagdoc : tagdocs_) {
            buf.append("<tr><td><a href=\"../");
            buf.append(tagdoc.getHref().getPath());
            buf.append("\">&lt;");
            buf.append(this.getLibraryNamespacePrefix());
            buf.append(':');
            buf.append(tagdoc.getName());
            buf.append("&gt;</a></td><td>");
            buf.append(tagdoc.getDescription());
            buf.append("</td>");
            if (displaySampleImages) {
                buf.append("<td>");
                BundleResourceRef sampleImage = tagdoc.getSampleImage();
                if (sampleImage != null) {
                    buf.append("<img src=\"../");
                    buf.append(sampleImage.getPath());
                    buf.append("\"/>");
                } else {
                    buf.append("&nbsp;");
                }
                buf.append("</td>");
            }
            buf.append("</tr>\n");
        }
        buf.append("</table>\n");
    }

    public ITopic getTocContributions() {
        this.initialize();
        HelpTopic root = new HelpTopic();
        root.setLabel(this.getLibraryTocTopicName());
        HelpTopic tagDocTopic = new HelpTopic();
        tagDocTopic.setLabel("Tag Reference");
        tagDocTopic.setResourceRef(this.getContentRef("summary/index.html"));
        root.addSubtopic((ITopic)tagDocTopic);
        for (String category : this.getCategories()) {
            HelpTopic tagCategoryTopic = new HelpTopic();
            tagCategoryTopic.setLabel(category);
            tagCategoryTopic.setResourceRef(this.getContentRef("summary/" + category + ".html"));
            tagDocTopic.addSubtopic((ITopic)tagCategoryTopic);
            for (TagDoc tagdoc : this.getTagDocs(category)) {
                HelpTopic tagTopic = new HelpTopic();
                tagTopic.setLabel(tagdoc.getName());
                tagTopic.setResourceRef(tagdoc.getHref());
                tagCategoryTopic.addSubtopic((ITopic)tagTopic);
            }
        }
        return root;
    }
}

