/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.tlei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineBreakType implements Enumerator
{
    NONE(0, "none", "none"),
    BEFORE_AFTER(1, "beforeAfter", "before-after"),
    BEFORE_INSIDE_AFTER(2, "beforeInsideAfter", "before-inside-after"),
    AFTER(3, "after", "after");

    public static final int NONE_VALUE = 0;
    public static final int BEFORE_AFTER_VALUE = 1;
    public static final int BEFORE_INSIDE_AFTER_VALUE = 2;
    public static final int AFTER_VALUE = 3;
    private static final LineBreakType[] VALUES_ARRAY;
    public static final List<LineBreakType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineBreakType[]{NONE, BEFORE_AFTER, BEFORE_INSIDE_AFTER, AFTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineBreakType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineBreakType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineBreakType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineBreakType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineBreakType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return BEFORE_AFTER;
            }
            case 2: {
                return BEFORE_INSIDE_AFTER;
            }
            case 3: {
                return AFTER;
            }
        }
        return null;
    }

    private LineBreakType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

