/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.tlei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InclusionUriType implements Enumerator
{
    RUNTIME(0, "runtime", "runtime"),
    COMPILE_TIME(1, "compileTime", "compile-time");

    public static final int RUNTIME_VALUE = 0;
    public static final int COMPILE_TIME_VALUE = 1;
    private static final InclusionUriType[] VALUES_ARRAY;
    public static final List<InclusionUriType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InclusionUriType[]{RUNTIME, COMPILE_TIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InclusionUriType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InclusionUriType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InclusionUriType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InclusionUriType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InclusionUriType get(int value) {
        switch (value) {
            case 0: {
                return RUNTIME;
            }
            case 1: {
                return COMPILE_TIME;
            }
        }
        return null;
    }

    private InclusionUriType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

