/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.ossmd.util;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.model.Activator;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.metadata.tlei.TleiEcoreMetaData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.internal.AttributeValueRuntimeTypeFactory;

public final class EMFMDAdapter {
    public static final String NO_SUFFIX = null;
    private static final ExtendedEcoreUtil ExtEcoreUtil = ExtendedEcoreUtil.INSTANCE;
    private Map<String, String> _translationMap = new HashMap<String, String>();

    public Trait getTagTrait(IFile file, EClass eClass, String key) {
        return this.getTagTrait(file, eClass, NO_SUFFIX, key);
    }

    public Trait getTagTrait(IFile file, EClass eClass, String suffix, String key) {
        Entity entity = this.getTagEntity(file, eClass, suffix);
        return this.getTagTrait(file, entity, (EObject)eClass, key);
    }

    public Trait getTagTrait(EObject eObj, EStructuralFeature feature, String key) {
        Entity entity = this.getTagEntity(eObj, feature);
        return this.getTagTrait(this.getFile(eObj), entity, eObj, key);
    }

    public Trait getTagTrait(IFile file, EObject eObj, EStructuralFeature feature, String key) {
        return this.getTagTrait(file, eObj.eClass(), feature, key);
    }

    public Trait getTagTrait(IFile file, EClass eClass, EStructuralFeature feature, String key) {
        Entity entity = this.getTagEntity(file, eClass, feature);
        return this.getTagTrait(file, entity, (EObject)eClass, key);
    }

    private Trait getTagTrait(IFile file, Entity entity, EObject eObj, String key) {
        if (entity == null) {
            return null;
        }
        IMetaDataQuery query = this.getMetaDataQuery(file);
        Trait pds = query.getQueryHelper().getTrait(entity, key);
        if (pds != null) {
            return pds;
        }
        return null;
    }

    public Entity getTagEntity(EObject eObj, EStructuralFeature feature) {
        IFile file = this.getFile(eObj);
        return this.getTagEntity(file, eObj.eClass(), feature);
    }

    private IFile getFile(EObject eObj) {
        IAdaptable existingAdapter;
        Resource res = eObj.eResource();
        IFile iFile = null;
        if (res != null && (existingAdapter = (IAdaptable)EcoreUtil.getExistingAdapter((Notifier)res, IAdaptable.class)) != null) {
            iFile = (IFile)existingAdapter.getAdapter(IFile.class);
        }
        return iFile;
    }

    public Entity getTagEntity(IFile file, EClass eClass, EStructuralFeature feature) {
        String entityId = this.createEntityId(eClass, feature);
        if (entityId != null) {
            return this.internalGetTagEntity(file, eClass, entityId);
        }
        return null;
    }

    private Entity internalGetTagEntity(IFile file, EClass eClass, String entityId) {
        IMetaDataQuery query = this.getMetaDataQuery(file);
        return query.getQueryHelper().getEntity(this.getTranslatedUri(ExtendedEcoreUtil.INSTANCE.getNamespaceUri(eClass)), entityId);
    }

    private IMetaDataQuery getMetaDataQuery(IFile file) {
        IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        return MetaDataQueryFactory.getInstance().createQuery(mdContext);
    }

    public Entity getTagEntity(IFile file, EClass eClass) {
        String entityId = this.createEntityId(eClass, NO_SUFFIX);
        if (entityId != null) {
            return this.internalGetTagEntity(file, eClass, entityId);
        }
        return null;
    }

    public Entity getTagEntity(IFile file, EClass eClass, String suffix) {
        String entityId = this.createEntityId(eClass, suffix);
        if (entityId != null) {
            return this.internalGetTagEntity(file, eClass, entityId);
        }
        return null;
    }

    public String createEntityId(EClass eClass, String suffix) {
        String nodeName = ExtEcoreUtil.getNodeName(eClass);
        if (nodeName != null && suffix != null) {
            nodeName = String.valueOf(nodeName) + suffix;
        }
        return nodeName;
    }

    private String createEntityId(EClass eClass, EStructuralFeature feature) {
        String nodeName = ExtEcoreUtil.getNodeName(eClass);
        String attrName = this.getAttrName(feature);
        if (nodeName != null && attrName != null) {
            return String.valueOf(nodeName) + "/" + attrName;
        }
        return null;
    }

    private String getAttrName(EStructuralFeature feature) {
        return ExtendedMetaData.INSTANCE.getName(feature);
    }

    public final ITypeDescriptor getTypeDelegate(EDataType dataType) {
        String runtimeTypeDelegate = TleiEcoreMetaData.INSTANCE.getRuntimeTypeDelegate(dataType);
        if (runtimeTypeDelegate != null) {
            ITypeDescriptor type = AttributeValueRuntimeTypeFactory.getInstance().getType(runtimeTypeDelegate);
            if (type == null) {
                LoggingService.logWarning((Plugin)Activator.getDefault(), (String)("No type for delegate id: " + runtimeTypeDelegate));
            }
            return type;
        }
        return null;
    }

    public void addTranslationMapping(String uri, String mdUri) {
        this._translationMap.put(uri, mdUri);
    }

    public void removeTranslationMapping(String uri) {
        if (this._translationMap.containsKey(uri)) {
            this._translationMap.remove(uri);
        }
    }

    public String getTranslatedUri(String uri) {
        if (this._translationMap.containsKey(uri)) {
            return this._translationMap.get(uri);
        }
        return uri;
    }
}

