/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.impl;

import oracle.eclipse.tools.xml.model.metadata.tlei.DependencyType;
import oracle.eclipse.tools.xml.model.metadata.tlei.ECoreAnnotations;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypeVariations;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class TleiMetaData {
    public static final TleiMetaData INSTANCE = new TleiMetaData();

    public SubTypes getSubtype(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)ECoreAnnotations.SUB_TYPE.getLiteral());
            if (value == null) {
                return null;
            }
            SubTypes type = SubTypes.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown subtype: " + value);
            }
            return type;
        }
        return null;
    }

    public SubTypeVariations getSubTypeVariation(EStructuralFeature feature) {
        String value;
        SubTypes subType = this.getSubtype(feature);
        if (subType != SubTypes.URI_SUBTYPE) {
            return null;
        }
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null && (value = (String)annotation.getDetails().get((Object)ECoreAnnotations.SUB_TYPE_VARIATION.getLiteral())) != null) {
            SubTypeVariations type = SubTypeVariations.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown subtype variation: " + value);
            }
            return type;
        }
        return null;
    }

    public DependencyType getDependencyType(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)ECoreAnnotations.DEPENDENCY_TYPE.getLiteral());
            if (value == null) {
                if (SubTypes.URI_SUBTYPE.equals((Object)this.getSubtype(feature)) || SubTypes.IMAGE_URI_SUBTYPE.equals((Object)this.getSubtype(feature)) || SubTypes.XML_URI_SUBTYPE.equals((Object)this.getSubtype(feature))) {
                    return DependencyType.FILE_REFERENCE;
                }
                return null;
            }
            DependencyType type = DependencyType.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown dependency: " + value);
            }
            return type;
        }
        return null;
    }

    private TleiMetaData() {
    }
}

