/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.util.AbstractMatcher;
import oracle.eclipse.tools.xml.model.dynpkg.DynamicExtendedMetaData;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.BasicEcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.ConversionResult;
import oracle.eclipse.tools.xml.model.emfbinding.dom.EcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.ActionResultExportType;
import oracle.eclipse.tools.xml.model.metadata.tlei.ActionServletContextType;
import oracle.eclipse.tools.xml.model.metadata.tlei.InclusionUriType;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.metadata.tlei.TagAttributeMarkers;
import oracle.eclipse.tools.xml.model.metadata.tlei.TleiEcoreMetaData;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TagMetadata {
    public static final Set<SubTypes> ALL_SUBTYPES = Collections.emptySet();
    public static final Set<ActionResultExportType> ALL_ACTIONRESULTEXPORTTYPES = Collections.emptySet();
    public static final Set<ActionServletContextType> ALL_ACTIONSERVLETCONTEXTTYPES = Collections.emptySet();
    private final INamespaceContext _namespaceContext;
    private final INodeReader _nodeReader;
    private final EcoreNodeReader _ecoreReader;
    private final IXMLMetadataContext _metadataContext;
    private final DynamicExtendedMetaData _dmd;
    private static final String PAGE_INCLUDE_TRAIT_ID = "include-tag-is-page";
    private static final String INCLUDE_URI_TRAIT_ID = "include-tag-uri-attribute";

    public TagMetadata(INamespaceContext nsContext, IXMLMetadataContext mdContext, IFile baseFile) {
        this._dmd = new DynamicExtendedMetaData(baseFile);
        this._namespaceContext = nsContext;
        this._metadataContext = mdContext;
        this._nodeReader = INodeReader.INSTANCE;
        this._ecoreReader = new BasicEcoreNodeReader(this._nodeReader, this._namespaceContext);
        assert (this._namespaceContext != null);
    }

    public List<IFeatureData<Object>> findFeaturesWithSubtype(Node node, Collection<SubTypes> matchTypes) {
        if (node instanceof IDOMNode) {
            return this.findFeatures(node, new SubTypeMatcher(matchTypes, this._metadataContext, (IStructuredModel)((IDOMNode)node).getModel()));
        }
        return this.findFeatures(node, new SubTypeMatcher(matchTypes, this._metadataContext));
    }

    public Set<String> findAttributesWithSubtype(String uri, String elementName, Collection<SubTypes> matchTypes) {
        return this.findFeatures(uri, elementName, new SubTypeMatcher(matchTypes, this._metadataContext));
    }

    public List<IFeatureData<Object>> findFeaturesWithActionServletResultTypes(Node node, Collection<ActionResultExportType> matchTypes) {
        return this.findFeatures(node, new ActionResultExportTypeMatcher(matchTypes, this._metadataContext));
    }

    public List<IFeatureData<Object>> findFeatureWithActionServletContextTypes(Node node, Collection<ActionServletContextType> matchTypes) {
        return this.findFeatures(node, new ActionServletContextTypeMatcher(matchTypes, this._metadataContext));
    }

    protected List<IFeatureData<Object>> findFeatures(Node node, AbstractMatcher matcher) {
        if (!(node instanceof Element)) {
            return Collections.emptyList();
        }
        EClassifier type = this.getEClassifier(node);
        ArrayList<IFeatureData<Object>> values = new ArrayList<IFeatureData<Object>>();
        if (type instanceof EClass) {
            EList allStructuralFeatures = ((EClass)type).getEAllStructuralFeatures();
            for (EStructuralFeature feature : allStructuralFeatures) {
                if (!matcher.matches((Object)feature) || !this._ecoreReader.isSet(node, feature)) continue;
                IFeatureData featureData = this._ecoreReader.getFeatureData(node, feature, ConversionResult.IGNORE_RESULT);
                values.add(featureData);
            }
        }
        return values;
    }

    protected Set<String> findFeatures(String uri, String elementName, AbstractMatcher matcher) {
        EClassifier type = this.getEClassifier(uri, elementName);
        HashSet<String> values = Collections.EMPTY_SET;
        if (type instanceof EClass) {
            values = new HashSet<String>();
            EList allStructuralFeatures = ((EClass)type).getEAllStructuralFeatures();
            for (EStructuralFeature feature : allStructuralFeatures) {
                if (!matcher.matches((Object)feature) || ExtendedMetaData.INSTANCE.getFeatureKind(feature) != 2) continue;
                String attributeName = ExtendedMetaData.INSTANCE.getName(feature);
                values.add(attributeName);
            }
        }
        return values.isEmpty() ? Collections.EMPTY_SET : values;
    }

    public InclusionUriType getInclusionUriType(IDOMElement element, String attributeName) {
        EStructuralFeature feature;
        EClassifier eClassifier = this.getEClassifier((Node)element);
        if (eClassifier instanceof EClass && (feature = ((EClass)eClassifier).getEStructuralFeature(attributeName)) != null) {
            return TleiEcoreMetaData.INSTANCE.getInclusionUriType(feature);
        }
        return this.checkMDForInclusionType(element);
    }

    private InclusionUriType checkMDForInclusionType(IDOMElement element) {
        String uri = this._namespaceContext.getNamespace((Node)element);
        String entityKey = INodeReader.INSTANCE.getElementQName((Element)element);
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(this._metadataContext.getMetaDataDomainContext());
        Trait trait = query.getQueryHelper().getTrait(uri, entityKey, PAGE_INCLUDE_TRAIT_ID);
        String value = TraitValueHelper.getValueAsString((Trait)trait);
        boolean isPageInclude = true;
        if (value != null) {
            isPageInclude = Boolean.valueOf(value);
        }
        if (!isPageInclude) {
            return InclusionUriType.COMPILE_TIME;
        }
        return InclusionUriType.RUNTIME;
    }

    public String getIncludeUriAttribute(IDOMElement element) {
        EStructuralFeature feature;
        String tagAttributeMarker;
        EClassifier eClassifier = this.getEClassifier((Node)element);
        if (eClassifier instanceof EClass && (tagAttributeMarker = TleiEcoreMetaData.INSTANCE.getTagAttributeMarker((EClass)eClassifier, TagAttributeMarkers.INCLUDE_TAG_URI_ATTRIBUTE)) != null && (feature = ((EClass)eClassifier).getEStructuralFeature(tagAttributeMarker)) != null) {
            return ExtendedMetaData.INSTANCE.getName(feature);
        }
        return this.checkMDForAttribute(element);
    }

    private String checkMDForAttribute(IDOMElement element) {
        IMetaDataDomainContext mdContext;
        String uri = this._namespaceContext.getNamespace((Node)element);
        if (uri != null && (mdContext = this._metadataContext.getMetaDataDomainContext()) != null) {
            IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(this._metadataContext.getMetaDataDomainContext());
            Trait trait = query.getQueryHelper().getTrait(uri, this._nodeReader.getElementQName((Element)element), INCLUDE_URI_TRAIT_ID);
            return TraitValueHelper.getValueAsString((Trait)trait);
        }
        return null;
    }

    private EClassifier getEClassifier(Node node) {
        EPackage ePackage = this.getEPackage(node);
        if (ePackage != null) {
            String nodeName = this._nodeReader.getElementQName((Element)node);
            String annotationName = ExtendedEcoreUtil.INSTANCE.getAnnotationName(nodeName);
            if (nodeName != null && annotationName != null) {
                return this._dmd.getType(ePackage, annotationName);
            }
        }
        return null;
    }

    private EClassifier getEClassifier(String uri, String elementName) {
        String annotationName;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
        if (ePackage != null && (annotationName = ExtendedEcoreUtil.INSTANCE.getAnnotationName(elementName)) != null) {
            return this._dmd.getType(ePackage, annotationName);
        }
        return null;
    }

    private EPackage getEPackage(Node node) {
        String uri = this._namespaceContext.getNamespace(node);
        if (uri == null) {
            return null;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
        return ePackage;
    }

    private static class ActionResultExportTypeMatcher
    extends EnumTypeMatcher<ActionResultExportType> {
        public ActionResultExportTypeMatcher(Collection<ActionResultExportType> matchTypes, IXMLMetadataContext mdContext) {
            super(matchTypes, ALL_ACTIONRESULTEXPORTTYPES, mdContext);
        }

        @Override
        protected ActionResultExportType getEnumType(EStructuralFeature feature) {
            return TleiEcoreMetaData.INSTANCE.getActionResultExportType(feature);
        }
    }

    private static class ActionServletContextTypeMatcher
    extends EnumTypeMatcher<ActionServletContextType> {
        public ActionServletContextTypeMatcher(Collection<ActionServletContextType> matchTypes, IXMLMetadataContext mdContext) {
            super(matchTypes, ALL_ACTIONSERVLETCONTEXTTYPES, mdContext);
        }

        @Override
        protected ActionServletContextType getEnumType(EStructuralFeature feature) {
            return TleiEcoreMetaData.INSTANCE.getActionServletContextType(feature);
        }
    }

    private static abstract class EnumTypeMatcher<ENUMTYPE>
    extends AbstractMatcher<EStructuralFeature> {
        private final Collection<ENUMTYPE> _matchTypes;
        private Collection<ENUMTYPE> _allValues;
        protected final IXMLMetadataContext _mdContext;
        protected final IStructuredModel _sModel;

        public EnumTypeMatcher(Collection<ENUMTYPE> matchTypes, Collection<ENUMTYPE> allValues, IXMLMetadataContext mdContext, IStructuredModel sModel) {
            this._matchTypes = matchTypes;
            this._allValues = allValues;
            this._mdContext = mdContext;
            this._sModel = sModel;
        }

        public EnumTypeMatcher(Collection<ENUMTYPE> matchTypes, Collection<ENUMTYPE> allValues, IXMLMetadataContext mdContext) {
            this(matchTypes, allValues, mdContext, null);
        }

        public final boolean matches(EStructuralFeature testMe) {
            ENUMTYPE enumType = this.getEnumType(testMe);
            return enumType != null && (this._matchTypes == this._allValues || this._matchTypes.contains(enumType));
        }

        protected abstract ENUMTYPE getEnumType(EStructuralFeature var1);
    }

    private static class SubTypeMatcher
    extends EnumTypeMatcher<SubTypes> {
        public SubTypeMatcher(Collection<SubTypes> matchTypes, IXMLMetadataContext mdContext, IStructuredModel model) {
            super(matchTypes, ALL_SUBTYPES, mdContext, model);
        }

        public SubTypeMatcher(Collection<SubTypes> matchTypes, IXMLMetadataContext mdContext) {
            super(matchTypes, ALL_SUBTYPES, mdContext);
        }

        @Override
        protected SubTypes getEnumType(EStructuralFeature feature) {
            return TleiAccess.INSTANCE.getSubtype(this._mdContext, this._sModel, feature);
        }
    }
}

