/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.eclipse.tools.xml.model.emfbinding.dom.SavingXMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class StructuredModelXMLDocumentProvider
extends SavingXMLDocumentProvider<IFile> {
    private final ModelRequestType _requestType;
    private IStructuredModel _model;

    public StructuredModelXMLDocumentProvider(ModelRequestType requestType) {
        this._requestType = requestType;
    }

    @Override
    public Document getXMLDocument(IFile source) {
        this.setLoadProblem(null);
        try {
            IModelManager manager = StructuredModelManager.getModelManager();
            switch (this._requestType) {
                case SHARED_READ: {
                    this._model = manager.getModelForRead(source);
                    break;
                }
                case SHARED_WRITE: {
                    this._model = manager.getModelForEdit(source);
                }
            }
            if (!(this._model instanceof IDOMModel)) {
                this.setLoadProblem(new Exception("Couldn't load file: " + source.toString()));
            }
            return ((IDOMModel)this._model).getDocument();
        }
        catch (IOException e) {
            this.setLoadProblem(e);
        }
        catch (CoreException e) {
            this.setLoadProblem((Exception)((Object)e));
        }
        return null;
    }

    public void release() {
        if (this._model != null) {
            switch (this._requestType) {
                case SHARED_READ: {
                    this._model.releaseFromRead();
                    break;
                }
                case SHARED_WRITE: {
                    this._model.releaseFromEdit();
                }
            }
            this._model = null;
        }
    }

    @Override
    public void saveXMLDocument() {
        this.setLoadProblem(null);
        if (this._requestType != ModelRequestType.SHARED_WRITE) {
            throw new IllegalStateException("Can only call write on a doc opened for write");
        }
        try {
            this._model.save();
        }
        catch (UnsupportedEncodingException e) {
            this.setLoadProblem(e);
        }
        catch (IOException e) {
            this.setLoadProblem(e);
        }
        catch (CoreException e) {
            this.setLoadProblem((Exception)((Object)e));
        }
    }

    public static enum ModelRequestType {
        SHARED_READ,
        SHARED_WRITE;

    }
}

