/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.ITreeHierarchyDelegate;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeToEObjectHiearchyDelegate
implements ITreeHierarchyDelegate<Node, EObject, EStructuralFeature> {
    private final Map<Node, EObject> _nodeToEObject = new HashMap<Node, EObject>();
    private final EStoreFactory _factory;
    private final INamespaceContext _context;

    public NodeToEObjectHiearchyDelegate(EStoreFactory factory, INamespaceContext context) {
        this._factory = factory;
        this._context = context;
    }

    @Override
    public EObject getChild(Node parent, Node child) {
        EClass eClass;
        assert (child.getParentNode() == parent);
        EObject childObj = this._nodeToEObject.get(child);
        if (childObj == null && child instanceof Element && (eClass = this.getType((Element)child)) != null && (childObj = this._factory.createEObject(eClass, child)) != null) {
            this._nodeToEObject.put(child, childObj);
        }
        return childObj;
    }

    private EClass getType(Element forNode) {
        String nodeName;
        String findName;
        String namespace = this._context.getNamespace(forNode);
        EClassifier eClassifier = ExtendedMetaData.INSTANCE.getType(namespace, findName = ExtendedEcoreUtil.INSTANCE.getAnnotationName(nodeName = INodeReader.INSTANCE.getElementQName(forNode)));
        if (eClassifier instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    @Override
    public List<EObject> getChildren(List<Node> parentType) {
        ArrayList<EObject> results = new ArrayList<EObject>();
        for (Node node : parentType) {
            EObject value = this.getChild(null, node);
            if (value == null) continue;
            results.add(value);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public EObject getParent(Node childNode) {
        EClass eClass;
        Node parentNode = childNode.getParentNode();
        EObject parentObj = this._nodeToEObject.get(parentNode);
        if (parentObj == null && parentNode instanceof Element && (eClass = this.getType((Element)parentNode)) != null && (parentObj = this._factory.getEObject(eClass, parentNode)) != null) {
            this._nodeToEObject.put(parentNode, parentObj);
        }
        return parentObj;
    }

    @Override
    public EObject getExisting(Node node) {
        return this._nodeToEObject.get(node);
    }

    @Override
    public void put(Node node, EObject type) {
        this._nodeToEObject.put(node, type);
    }
}

