/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import oracle.eclipse.tools.xml.model.TraceOptions;
import oracle.eclipse.tools.xml.model.dynpkg.DynamicExtendedMetaData;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.IEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.ITreeHierarchyDelegate;
import oracle.eclipse.tools.xml.model.emfbinding.dom.AbstractEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.EStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeBindingAdapterSource;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreImpl;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeToEObjectHiearchyDelegate;
import oracle.eclipse.tools.xml.model.service.EMFResourceAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEStoreEObjectImpl;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeEStoreFactory
implements EStoreFactory<Node> {
    private final INamespaceContext _nsContext;
    private final IFile _file;
    private final ITreeHierarchyDelegate<Node, EObject, EStructuralFeature> _treeDelegate;
    private final DynamicExtendedMetaData _extendedMD;
    private final Resource _tempResource;

    public NodeEStoreFactory(INamespaceContext nsContext, IFile file) {
        this._nsContext = nsContext;
        this._file = file;
        this._tempResource = this.createResource(NO_RESOURCESET);
        this._treeDelegate = new NodeToEObjectHiearchyDelegate(this, this._nsContext);
        this._extendedMD = new DynamicExtendedMetaData(this._file);
    }

    @Override
    public <T extends Node> InternalEObject.EStore createEStore(EClass eClass, T store) {
        EStoreNodeBindingAdapter adapter = new EStoreNodeBindingAdapter(this._nsContext, this._treeDelegate);
        return new NodeEStoreImpl(store, adapter, this._nsContext);
    }

    @Override
    public <T extends Node> EObject createEObject(EClass eClass, T store) {
        if (eClass == null || store == null) {
            return null;
        }
        EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (eObject instanceof DynamicEStoreEObjectImpl || eObject instanceof EStoreEObjectImpl) {
            InternalEObject.EStore eStore = this.createEStore(eClass, store);
            ((InternalEObject)eObject).eSetStore(eStore);
            if (eStore instanceof NodeEStoreImpl) {
                eObject.eAdapters().add((Object)((Adapter)((NodeEStoreImpl)eStore).getNodeBindingAdapter()));
            }
        }
        this._treeDelegate.put(store, eObject);
        return eObject;
    }

    @Override
    public <T extends Node> EObject createEObject(T store) {
        if (store == null) {
            return null;
        }
        String uri = this._nsContext.getNamespace(store);
        if (uri != null && store instanceof Element) {
            String name = INodeReader.INSTANCE.getElementQName((Element)store);
            EClass eClass = this.getEClass(uri, name);
            return this.createEObject(eClass, store);
        }
        return null;
    }

    @Override
    public final EClass getEClass(String namespaceUri, String tagName) {
        EClassifier eClass = this._extendedMD.getType(namespaceUri, ExtendedEcoreUtil.INSTANCE.getAnnotationName(tagName));
        if (eClass == null && TraceOptions.ESTORE) {
            TraceOptions.log("NodeEStoreFactory.getEClass(" + namespaceUri + ", " + tagName + "): EClass null for " + namespaceUri + ':' + tagName);
        }
        if (eClass instanceof EClass) {
            return (EClass)eClass;
        }
        return null;
    }

    @Override
    public <T extends Node> EObject getExistingEObject(T store) {
        return this._treeDelegate.getExisting(store);
    }

    @Override
    public <T extends Node> EObject getEObject(EClass eClass, T store) {
        EObject eObject = this.getExistingEObject(store);
        return eObject != null ? eObject : this.createEObject(eClass, store);
    }

    @Override
    public <T extends Node> EObject getEObject(T store) {
        EObject eObject = this.getExistingEObject(store);
        return eObject != null ? eObject : this.createEObject(store);
    }

    @Override
    public Resource createResource(ResourceSet resourceSet) {
        EMFResourceAdapter fileAdapter = new EMFResourceAdapter(this._file);
        Object resource = null;
        resource = resourceSet == NO_RESOURCESET ? new ResourceImpl() : resourceSet.createResource(URI.createPlatformResourceURI((String)this._file.getFullPath().toString(), (boolean)false));
        resource.eAdapters().add((Object)fileAdapter);
        return resource;
    }

    @Override
    public EObject createUnboundEObject(String namespaceUri, String tagName) {
        EClass eClass = this.getEClass(namespaceUri, tagName);
        return eClass == null ? null : this.createUnboundEObject(eClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EObject createUnboundEObject(EClass eClass) {
        Resource rsc;
        if (eClass == null) {
            return null;
        }
        EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (eObject instanceof DynamicEStoreEObjectImpl || eObject instanceof EStoreEObjectImpl) {
            ((InternalEObject)eObject).eSetStore((InternalEObject.EStore)new DefaultEStoreImpl(this._nsContext));
        }
        Resource resource = rsc = this.getTemporaryResource();
        synchronized (resource) {
            rsc.getContents().add((Object)eObject);
        }
        return eObject;
    }

    protected Resource getTemporaryResource() {
        return this._tempResource;
    }

    private static final class DefaultEStoreImpl
    extends EStoreEObjectImpl.EStoreImpl
    implements INodeBindingAdapterSource {
        private final DefaultEStoreNodeBindingAdapter _bindingAdapter = new DefaultEStoreNodeBindingAdapter();
        private final INamespaceContext _nsContext;

        public DefaultEStoreImpl(INamespaceContext nsContext) {
            this._nsContext = nsContext;
        }

        @Override
        public IEStoreNodeBindingAdapter getNodeBindingAdapter() {
            return this._bindingAdapter;
        }

        @Override
        public INamespaceContext getNamespaceContext() {
            return this._nsContext;
        }
    }

    private static final class DefaultEStoreNodeBindingAdapter
    extends AbstractEStoreNodeBindingAdapter {
        private DefaultEStoreNodeBindingAdapter() {
        }

        @Override
        public IEStoreNodeBindingAdapter.ReadResult getFeature(InternalEObject boundEObject, Node boundNode, EStructuralFeature feature, int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IEStoreNodeBindingAdapter.ReadResult setFeature(InternalEObject boundObject, Node boundNode, EStructuralFeature feature, int index, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EObject getContainer(Node boundNode) {
            throw new UnsupportedOperationException();
        }
    }
}

