/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import oracle.eclipse.tools.xml.model.dynpkg.DynamicExtendedMetaData;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.IEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeBindingAdapterSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class NodeAdapterEStoreEObjectImpl
extends EStoreEObjectImpl
implements INodeAdapter {
    public NodeAdapterEStoreEObjectImpl() {
    }

    public NodeAdapterEStoreEObjectImpl(EClass eClass, InternalEObject.EStore eStore) {
        super(eClass, eStore);
    }

    public NodeAdapterEStoreEObjectImpl(EClass eClass) {
        super(eClass);
    }

    public NodeAdapterEStoreEObjectImpl(InternalEObject.EStore eStore) {
        super(eStore);
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof IDOMElement) {
            IDOMElement domElement = (IDOMElement)notifier;
            IFile file = this.getFile(domElement);
            switch (eventType) {
                case 2: {
                    if (!(newValue instanceof Text)) break;
                    this.handleAdd(domElement, file, (Text)newValue);
                    break;
                }
                case 3: {
                    if (!(oldValue instanceof Text)) break;
                    this.handleRemove(domElement, file, (Text)oldValue);
                    break;
                }
                case 5: {
                    if (!(changedFeature instanceof Text) || !(newValue instanceof String)) break;
                    this.handleContentChanged(domElement, file, (String)newValue);
                    break;
                }
                case 1: {
                    if (!(changedFeature instanceof IDOMAttr)) break;
                    IDOMAttr attribute = (IDOMAttr)changedFeature;
                    this.handleChange(oldValue, newValue, attribute, domElement, file);
                }
            }
        }
    }

    public IEStoreNodeBindingAdapter getBindingAdapter() {
        INodeBindingAdapterSource source = this.getBindingAdapterSource();
        return source == null ? null : source.getNodeBindingAdapter();
    }

    private INodeBindingAdapterSource getBindingAdapterSource() {
        InternalEObject.EStore store = this.eStore();
        if (!(store instanceof INodeBindingAdapterSource)) {
            return null;
        }
        return (INodeBindingAdapterSource)store;
    }

    public INamespaceContext getNamespaceContext() {
        INodeBindingAdapterSource source = this.getBindingAdapterSource();
        return source == null ? null : source.getNamespaceContext();
    }

    private String getUri(IDOMElement domElement) {
        INamespaceContext nsContext = this.getNamespaceContext();
        if (nsContext == null) {
            return null;
        }
        return nsContext.getNamespace((Node)domElement);
    }

    private EClass getEClass(String elementName, String uri, IFile file) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
        String findName = ExtendedEcoreUtil.INSTANCE.getAnnotationName(elementName);
        EClass eClass = (EClass)new DynamicExtendedMetaData(file).getType(ePackage, findName);
        return eClass;
    }

    private IFile getFile(IDOMElement domElement) {
        IStructuredDocument structuredDoc = domElement.getStructuredDocument();
        if (structuredDoc == null) {
            return null;
        }
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)structuredDoc, -1);
        if (context == null) {
            return null;
        }
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        if (resolver == null) {
            return null;
        }
        IResource resource = resolver.getResource();
        if (resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private void handleAdd(IDOMElement domElement, IFile file, Text newValue) {
        EClass eClass;
        String elementName = domElement.getLocalName();
        String uri = this.getUri(domElement);
        if (elementName != null && uri != null && (eClass = this.getEClass(elementName, uri, file)) != null) {
            EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getTextContentFeature(eClass);
            this.fireSetEvent(null, newValue.getNodeValue(), eClass, feature);
        }
    }

    private void handleRemove(IDOMElement domElement, IFile file, Text oldValue) {
        EClass eClass;
        String elementName = domElement.getLocalName();
        String uri = this.getUri(domElement);
        if (elementName != null && uri != null && (eClass = this.getEClass(elementName, uri, file)) != null) {
            EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getTextContentFeature(eClass);
            this.fireSetEvent(oldValue.getNodeValue(), null, eClass, feature);
        }
    }

    private void handleContentChanged(IDOMElement domElement, IFile file, String newValue) {
        EClass eClass;
        String elementName = domElement.getLocalName();
        String uri = this.getUri(domElement);
        if (elementName != null && uri != null && (eClass = this.getEClass(elementName, uri, file)) != null) {
            EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getTextContentFeature(eClass);
            this.fireSetEvent(null, newValue, eClass, feature);
        }
    }

    private void handleChange(Object oldValue, Object newValue, IDOMAttr attribute, IDOMElement domElement, IFile file) {
        String elementName = domElement.getLocalName();
        String uri = this.getUri(domElement);
        if (elementName != null && uri != null) {
            int dynamicFeatureId;
            EClass eClass = this.getEClass(elementName, uri, file);
            if (eClass == null) {
                return;
            }
            EStructuralFeature feature = new DynamicExtendedMetaData(file).getAttribute(eClass, null, attribute.getLocalName());
            if (feature == null) {
                return;
            }
            if (this.eSettings == null) {
                this.eSettings();
            }
            if ((dynamicFeatureId = this.eDerivedStructuralFeatureID(feature)) < 0 || dynamicFeatureId > this.eSettings.length) {
                System.out.println("Had to clear the feature value cache for " + (Object)((Object)this));
                this.eSettings = ENO_SETTINGS;
            } else {
                this.eSettings[dynamicFeatureId] = null;
            }
            this.fireSetEvent(oldValue, newValue, eClass, feature);
        }
    }

    private void fireSetEvent(Object oldValue, Object newValue, EClass eClass, EStructuralFeature feature) {
        if (eClass != null && feature != null) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, this.eClass().getFeatureID(feature), oldValue, newValue));
        }
    }
}

