/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Node;

public final class FeatureData<T>
implements IFeatureData<T> {
    private final EStructuralFeature _feature;
    private final List<ValueHolder<T>> _values;

    public static <T> FeatureData<T> create(EStructuralFeature feature) {
        return new FeatureData<T>(feature);
    }

    private FeatureData(EStructuralFeature feature) {
        this._feature = feature;
        this._values = new ArrayList<ValueHolder<T>>();
    }

    public void addValue(Node valueOwner, Object typedValue) {
        this._values.add(new ValueHolder<Object>(valueOwner, typedValue));
    }

    @Override
    public EStructuralFeature getFeature() {
        return this._feature;
    }

    @Override
    public List<ValueHolder<T>> getValues() {
        return Collections.unmodifiableList(this._values);
    }

    @Override
    public List<T> getOnlyValues() {
        return new DelegatingEList.UnmodifiableEList(this._values){

            protected T delegateGet(int index) {
                return ((ValueHolder)FeatureData.this._values.get(index)).getValue();
            }
        };
    }

    public static final class ValueHolder<T> {
        private final Node _node;
        private final T _value;

        public ValueHolder(Node node, T value) {
            this._node = node;
            this._value = value;
        }

        public Node getNode() {
            return this._node;
        }

        public T getValue() {
            return this._value;
        }
    }
}

