/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.xml.model.emfbinding.DiagnosticAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.DiagnosticFacade;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.IEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.ITreeHierarchyDelegate;
import oracle.eclipse.tools.xml.model.emfbinding.dom.AbstractEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.BasicEcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.ConversionResult;
import oracle.eclipse.tools.xml.model.emfbinding.dom.EcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EStoreNodeBindingAdapter
extends AbstractEStoreNodeBindingAdapter
implements IEStoreNodeBindingAdapter {
    private static final String EDATA_TYPE_VALIDATOR_SOURCE = "EDataTypeValidator";
    private static final DOMHandler DOM_HANDLER = new DOMHandler();
    private final EcoreNodeReader _ecoreNodeReader;
    private final ITreeHierarchyDelegate<Node, EObject, EStructuralFeature> _treeDelegate;
    private Map<String, Object> _data = null;

    public EStoreNodeBindingAdapter(INamespaceContext nsContext, ITreeHierarchyDelegate<Node, EObject, EStructuralFeature> delegate) {
        this._ecoreNodeReader = new BasicEcoreNodeReader(INodeReader.INSTANCE, nsContext);
        this._treeDelegate = delegate;
    }

    public boolean isAdapterForType(Object type) {
        if (!IEStoreNodeBindingAdapter.class.equals(type)) {
            return super.isAdapterForType(type);
        }
        return true;
    }

    @Override
    public IEStoreNodeBindingAdapter.ReadResult getFeature(InternalEObject boundEObject, Node boundNode, EStructuralFeature feature, int index) {
        ConversionResult result = new ConversionResult();
        IFeatureData featureData = null;
        this.clearProblem(EDATA_TYPE_VALIDATOR_SOURCE, (EObject)boundEObject, feature);
        featureData = this._ecoreNodeReader.getFeatureData(boundNode, feature, result);
        if (result.isWasBadValue()) {
            this.addProblem(EDATA_TYPE_VALIDATOR_SOURCE, boundNode, (EObject)boundEObject, feature, result.getThrowable());
            return IEStoreNodeBindingAdapter.ReadResult.create(feature.getDefaultValue(), IEStoreNodeBindingAdapter.ReadResult.SetStatus.SET_INVALID);
        }
        if (feature.getEType() instanceof EDataType) {
            return this.getSimpleData(feature, index, featureData);
        }
        return this.getComplexType(boundNode, index, featureData);
    }

    @Override
    public IEStoreNodeBindingAdapter.ReadResult setFeature(InternalEObject boundObject, Node boundNode, EStructuralFeature feature, int index, Object value) {
        ExtendedMetaData ExtMD = ExtendedMetaData.INSTANCE;
        int kind = ExtMD.getFeatureKind(feature);
        String name = ExtMD.getName(feature);
        switch (kind) {
            case 2: {
                IEStoreNodeBindingAdapter.ReadResult oldValue = this.getFeature(boundObject, boundNode, feature, index);
                Node node = boundNode.getAttributes().getNamedItem(name);
                if (node == null) {
                    if (value != null) {
                        Attr newAttr = boundNode.getOwnerDocument().createAttribute(name);
                        newAttr.setNodeValue(value.toString());
                        boundNode.getAttributes().setNamedItem(newAttr);
                    }
                } else if (node.getNodeType() == 2) {
                    if (value != null) {
                        Attr attr = (Attr)node;
                        attr.setValue(value.toString());
                    } else {
                        boundNode.getAttributes().removeNamedItem(name);
                    }
                } else {
                    throw new IllegalStateException(String.format("Expected an attribute but found %d for feature: %s", node.getNodeType(), feature.toString()));
                }
                return oldValue;
            }
            case 0: {
                if (!ExtendedEcoreUtil.INSTANCE.isTextContentFeature(feature) || feature.isMany()) break;
                IEStoreNodeBindingAdapter.ReadResult oldValue = this.getFeature(boundObject, boundNode, feature, index);
                DOM_HANDLER.setTextContent(boundNode, UTIL.compressTextContent(feature, value));
                return oldValue;
            }
        }
        return null;
    }

    @Override
    public EObject getContainer(Node boundNode) {
        return this._treeDelegate.getParent(boundNode);
    }

    protected void clearProblem(String source, EObject eObject, EStructuralFeature feature) {
        DiagnosticAdapter.clearDiagnostics(source, eObject, feature);
    }

    protected void addProblem(String source, Node node, EObject eObject, EStructuralFeature feature, Throwable throwable) {
        Resource.Diagnostic diagnostic = null;
        if (throwable instanceof Resource.Diagnostic) {
            diagnostic = (Resource.Diagnostic)throwable;
        } else if (node instanceof IDOMNode) {
            diagnostic = new DiagnosticFacade((Diagnostic)new BasicDiagnostic(source, -1, throwable.getLocalizedMessage(), new Object[]{throwable}), (IDOMNode)node, eObject, feature);
        } else {
            throw new IllegalStateException("Unsupported diagnostic case");
        }
        DiagnosticAdapter.addDiagnostic(eObject, diagnostic);
    }

    protected IEStoreNodeBindingAdapter.ReadResult getSimpleData(EStructuralFeature feature, int index, IFeatureData<? extends Object> featureData) {
        if (featureData.getOnlyValues().isEmpty()) {
            return IEStoreNodeBindingAdapter.ReadResult.UNSET_RESULT;
        }
        if (index == -1) {
            if (feature.isMany()) {
                return IEStoreNodeBindingAdapter.ReadResult.create(featureData.getOnlyValues(), IEStoreNodeBindingAdapter.ReadResult.SetStatus.SET_VALID);
            }
            return IEStoreNodeBindingAdapter.ReadResult.create(featureData.getOnlyValues().get(0), IEStoreNodeBindingAdapter.ReadResult.SetStatus.SET_VALID);
        }
        return IEStoreNodeBindingAdapter.ReadResult.create(featureData.getOnlyValues().get(index), IEStoreNodeBindingAdapter.ReadResult.SetStatus.SET_VALID);
    }

    protected IEStoreNodeBindingAdapter.ReadResult getComplexType(Node boundNode, int index, IFeatureData<? extends Object> featureData) {
        List<? extends Object> nodes = featureData.getOnlyValues();
        if (nodes.isEmpty()) {
            return IEStoreNodeBindingAdapter.ReadResult.UNSET_RESULT;
        }
        if (index == -1) {
            Object value;
            if (featureData.getFeature().isMany()) {
                List<EObject> objects = this._treeDelegate.getChildren(nodes);
                if (objects.isEmpty()) {
                    Object var5_7 = null;
                }
                value = objects;
            } else {
                value = this._treeDelegate.getChild(boundNode, (Node)nodes.get(0));
            }
            if (value == null) {
                return IEStoreNodeBindingAdapter.ReadResult.UNSET_RESULT;
            }
            return IEStoreNodeBindingAdapter.ReadResult.create(value, IEStoreNodeBindingAdapter.ReadResult.SetStatus.SET_VALID);
        }
        Node node = (Node)nodes.get(index);
        EObject value = this._treeDelegate.getChild(boundNode, node);
        if (value == null) {
            return IEStoreNodeBindingAdapter.ReadResult.UNSET_RESULT;
        }
        return IEStoreNodeBindingAdapter.ReadResult.create(value, IEStoreNodeBindingAdapter.ReadResult.SetStatus.SET_VALID);
    }

    @Override
    public void setData(String key, Object value) {
        if (this._data == null) {
            this._data = new HashMap<String, Object>();
        }
        this._data.put(key, value);
    }

    @Override
    public <T> T getData(String key) {
        if (this._data == null) {
            return null;
        }
        return (T)this._data.get(key);
    }

    private static class DOMHandler {
        private DOMHandler() {
        }

        public void setTextContent(Node node, String text) {
            this.replaceTextNodes(node, text);
        }

        private void replaceTextNodes(Node node, String newText) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 3) {
                    node.removeChild(child);
                }
                ++i;
            }
            node.appendChild(node.getOwnerDocument().createTextNode(newText));
        }
    }
}

