/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.ConversionResult;
import oracle.eclipse.tools.xml.model.emfbinding.dom.EcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.FeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicEcoreNodeReader
implements EcoreNodeReader {
    protected static final ExtendedMetaData ExtMD = ExtendedMetaData.INSTANCE;
    private final INodeReader _nodeReader;
    private final INamespaceContext _namespaceContext;

    public BasicEcoreNodeReader(INodeReader nodeReader, INamespaceContext namespaceContext) {
        this._nodeReader = nodeReader;
        this._namespaceContext = namespaceContext;
    }

    @Override
    public String getRawValue(Node node, EStructuralFeature feature) {
        List<String> rawValues = this.getRawValues(node, feature);
        if (!rawValues.isEmpty()) {
            return rawValues.get(0);
        }
        return null;
    }

    private String getRawValueAttribute(Node node, String attrName) {
        return this._nodeReader.getAttributeValue(node, attrName);
    }

    @Override
    public List<String> getRawValues(Node node, EStructuralFeature feature) {
        int kind = ExtMD.getFeatureKind(feature);
        String name = ExtMD.getName(feature);
        ArrayList<String> values = new ArrayList<String>();
        switch (kind) {
            case 2: {
                values.add(this.getRawValueAttribute(node, name));
                break;
            }
            case 4: {
                EClassifier type = feature.getEType();
                if (!(type instanceof EDataType)) break;
                for (FeatureData.ValueHolder<String> valueHolder : this.getRawElementValues(node, feature, name)) {
                    values.add(valueHolder.getValue());
                }
                break;
            }
        }
        return values;
    }

    @Override
    public Object getValue(Node node, EStructuralFeature feature) {
        return this.getValue(node, feature, ConversionResult.IGNORE_RESULT);
    }

    @Override
    public Object getValue(Node node, EStructuralFeature feature, ConversionResult result) {
        IFeatureData<? extends Object> featureData = this.getFeatureData(node, feature, result);
        List<FeatureData.ValueHolder<? extends Object>> valueHolder = featureData.getValues();
        if (valueHolder.size() == 1) {
            return valueHolder.get(0).getValue();
        }
        if (valueHolder.size() > 1) {
            return featureData.getOnlyValues();
        }
        return null;
    }

    public IFeatureData<? extends Object> getFeatureData(Node node, EStructuralFeature feature, ConversionResult result) {
        int kind = ExtMD.getFeatureKind(feature);
        String name = ExtMD.getName(feature);
        FeatureData<Object> featureData = FeatureData.create(feature);
        switch (kind) {
            case 2: {
                String text = this.getRawValueAttribute(node, name);
                Object value = this.createFromString(feature, text, result);
                featureData.addValue(this._nodeReader.getAttribute(node, name), value);
                return featureData;
            }
            case 4: {
                EClassifier type = feature.getEType();
                if (type instanceof EDataType) {
                    featureData = this.handleSimpleTypeElementGet(node, feature, name, result, featureData);
                } else if (type instanceof EClass) {
                    featureData = this.handleEClassElementGet(feature, (EClass)type, node, name);
                }
                return featureData;
            }
            case 0: {
                if (!ExtendedEcoreUtil.INSTANCE.isTextContentFeature(feature) || feature.isMany()) break;
                String value = this._nodeReader.getTextContent(node);
                featureData.addValue(this._nodeReader.getAttribute(node, name), value);
                return featureData;
            }
        }
        return featureData;
    }

    private Object handleDataTypeGet(EStructuralFeature feature, String stringValue, ConversionResult result) {
        return this.createFromString(feature, stringValue, result);
    }

    private FeatureData<Node> handleEClassElementGet(EStructuralFeature feature, EClass eClass, Node boundNode, String name) {
        FeatureData<Node> featureData = FeatureData.create(feature);
        NodeList nodes = boundNode.getChildNodes();
        String namespace = eClass.getEPackage().getNsURI() == null ? "" : eClass.getEPackage().getNsURI();
        int i = 0;
        while (i < nodes.getLength()) {
            String tagName;
            Node child = nodes.item(i);
            if (child != null && child.getNodeType() == 1 && (tagName = this._nodeReader.getElementQName((Element)child)) != null && tagName.equals(name) && namespace.equals(this._namespaceContext.getNamespace(child))) {
                featureData.addValue(child, child);
            }
            ++i;
        }
        return featureData;
    }

    private FeatureData<Object> handleSimpleTypeElementGet(Node node, EStructuralFeature feature, String subElementName, ConversionResult result, FeatureData featureData) {
        assert (feature.getEType() instanceof EDataType);
        List<FeatureData.ValueHolder<String>> stringValues = this.getRawElementValues(node, feature, subElementName);
        for (FeatureData.ValueHolder<String> strHolder : stringValues) {
            featureData.addValue(strHolder.getNode(), this.handleDataTypeGet(feature, strHolder.getValue(), result));
        }
        return featureData;
    }

    @Override
    public boolean isSet(Node node, EStructuralFeature feature) {
        return !this.getRawValues(node, feature).isEmpty();
    }

    private Object createFromString(EStructuralFeature feature, String text, ConversionResult result) {
        if (text == null) {
            return feature.getDefaultValue();
        }
        try {
            return EcoreUtil.createFromString((EDataType)((EDataType)feature.getEType()), (String)text);
        }
        catch (Exception e) {
            result.setThrowable(e);
            return INVALID_VALUE;
        }
    }

    private List<FeatureData.ValueHolder<String>> getRawElementValues(Node node, EStructuralFeature feature, String subElementName) {
        NodeList nodes = node.getChildNodes();
        ArrayList<FeatureData.ValueHolder<String>> values = new ArrayList<FeatureData.ValueHolder<String>>();
        String nsURI = feature.getEContainingClass().getEPackage().getNsURI();
        nsURI = nsURI == null ? "" : nsURI;
        int i = 0;
        while (i < nodes.getLength()) {
            String tagName;
            Node child = nodes.item(i);
            if (child instanceof Element && (tagName = this._nodeReader.getElementQName((Element)child)) != null && tagName.equals(subElementName) && nsURI.equals(this._namespaceContext.getNamespace(child))) {
                String stringValue = this._nodeReader.getTextContent(child);
                values.add(new FeatureData.ValueHolder<String>(child, stringValue));
            }
            ++i;
        }
        return values;
    }
}

