/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import oracle.eclipse.tools.xml.model.emfbinding.BoundEObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractLoadFromDOMResource
extends XMLResourceImpl {
    protected Document _backingDocument;

    public Document getBackingDocument() {
        return this._backingDocument;
    }

    public abstract void doLoad(InputSource var1, Map<?, ?> var2) throws IOException;

    protected final void parent_doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        super.doLoad(inputSource, options);
    }

    public abstract void doLoad(InputStream var1, Map<?, ?> var2) throws IOException;

    protected final void parent_doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
    }

    protected void doUnload() {
        ArrayList copyContents = new ArrayList(this.getContents());
        super.doUnload();
        for (EObject eObj : copyContents) {
            this.visitAndUnbind(eObj);
        }
        this._backingDocument = null;
    }

    private void visitAndUnbind(EObject eObj) {
        for (EObject child : eObj.eContents()) {
            this.visitAndUnbind(child);
        }
        if (eObj instanceof BoundEObject) {
            ((BoundEObject)eObj).unbind();
            eObj.eAdapters().clear();
        }
    }

    protected void unloaded(InternalEObject internalEObject) {
        internalEObject.eSetProxyURI(this.uri.appendFragment(this.getURIFragment((EObject)internalEObject)));
        if (!(internalEObject instanceof BoundEObject)) {
            internalEObject.eAdapters().clear();
        }
    }

    protected XMLLoad createXMLLoad() {
        return new MyXMLLoad();
    }

    protected final void throwWrappingIOException(String message, Exception wrapThis) throws IOException {
        IOException throwMe = new IOException(message);
        throwMe.initCause(wrapThis);
        throw throwMe;
    }

    protected AbstractLoadFromDOMResource(URI uri) {
        super(uri);
    }

    protected static class MySAXXMLHandler
    extends SAXXMLHandler {
        public MySAXXMLHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
            super(xmiResource, helper, options);
        }

        private boolean isTop() {
            return this.objects.isEmpty();
        }
    }

    protected static class MyXMLHelper
    extends XMLHelperImpl {
        private Node _curNode;
        private MySAXXMLHandler _handler;

        protected MyXMLHelper() {
        }

        public void setXMLHandler(MySAXXMLHandler handler) {
            this._handler = handler;
        }

        public Node getCurNode() {
            return this._curNode;
        }

        public void setCurNode(Node node) {
            this._curNode = node;
        }

        public EObject createObject(EFactory factory, EClassifier type) {
            EObject eobj = super.createObject(factory, type);
            if (eobj instanceof BoundEObject && !this._handler.isTop()) {
                throw new AssertionError();
            }
            return eobj;
        }

        public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
            if (ExtendedMetaData.INSTANCE.isDocumentRoot(object.eClass())) {
                super.setValue(object, feature, value, position);
            }
        }
    }

    protected static class MyXMLLoad
    extends XMLLoadImpl {
        public MyXMLLoad() {
            super((XMLHelper)new MyXMLHelper());
        }

        protected void traverse(Node node, XMLLoadImpl.AttributesProxy attributesProxy, DefaultHandler handler, LexicalHandler lexicalHandler) throws SAXException {
            this.getHelper().setCurNode(node);
            super.traverse(node, attributesProxy, handler, lexicalHandler);
        }

        protected void traverseElement(Element element, XMLLoadImpl.AttributesProxy attributesProxy, DefaultHandler handler, LexicalHandler lexicalHandler) throws SAXException {
            super.traverseElement(element, attributesProxy, handler, lexicalHandler);
        }

        protected DefaultHandler makeDefaultHandler() {
            MySAXXMLHandler handler = new MySAXXMLHandler(this.resource, this.helper, this.options);
            this.getHelper().setXMLHandler(handler);
            return handler;
        }

        private MyXMLHelper getHelper() {
            return (MyXMLHelper)this.helper;
        }
    }
}

