/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.w3c.dom.Node;

public interface IEStoreNodeBindingAdapter {
    public static final BindingUtil UTIL = new BindingUtil();

    public ReadResult getFeature(InternalEObject var1, Node var2, EStructuralFeature var3, int var4);

    public ReadResult setFeature(InternalEObject var1, Node var2, EStructuralFeature var3, int var4, Object var5);

    public EObject getContainer(Node var1);

    public void setData(String var1, Object var2);

    public <T> T getData(String var1);

    public static final class BindingUtil {
        private BindingUtil() {
        }

        public String compressTextContent(EObject owner, EStructuralFeature wrappingFeature, EStructuralFeature containedFeature) {
            Object wrappedValue = owner.eGet(wrappingFeature);
            return this.compressTextContent(containedFeature, wrappedValue);
        }

        public String compressTextContent(EStructuralFeature containedFeature, Object wrappedValue) {
            String retValue = null;
            if (wrappedValue instanceof FeatureMap) {
                FeatureMap fMap = (FeatureMap)wrappedValue;
                Object fVal = fMap.get(containedFeature, true);
                retValue = fVal instanceof Collection ? this.concat((Collection)fVal) : fVal.toString();
            } else if (wrappedValue instanceof Collection) {
                retValue = this.concat((Collection)wrappedValue);
            } else if (wrappedValue != null) {
                retValue = wrappedValue.toString();
            }
            return retValue;
        }

        public String concat(Collection<Object> list) {
            String retValue = null;
            for (Object value : list) {
                if (value == null) continue;
                if (retValue == null) {
                    retValue = "";
                }
                retValue = String.valueOf(retValue) + value;
            }
            return retValue;
        }
    }

    public static final class ReadResult {
        public static final ReadResult UNSET_RESULT = new ReadResult(null, SetStatus.UNSET);
        private final Object _value;
        private final SetStatus _setStatus;

        public static ReadResult create(Object value, SetStatus status) {
            return new ReadResult(value, status);
        }

        private ReadResult(Object value, SetStatus status) {
            this._value = value;
            this._setStatus = status;
        }

        public Object getValue() {
            return this._value;
        }

        public boolean isValid() {
            return this._setStatus != SetStatus.SET_INVALID;
        }

        public boolean isSet() {
            return this._setStatus != SetStatus.UNSET;
        }

        public static enum SetStatus {
            UNSET,
            SET_VALID,
            SET_INVALID;

        }
    }
}

