/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding;

import oracle.eclipse.tools.xml.model.emfbinding.BoundEObject;
import oracle.eclipse.tools.xml.model.emfbinding.DefaultBackStoreBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.IBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeBindingAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BoundEObjectImpl
extends EObjectImpl
implements BoundEObject {
    protected IBindingAdapter _adapter;
    private boolean _recurse;
    private boolean _isBound;
    private boolean _isUpdateBoundData;

    public BoundEObjectImpl() {
        DefaultBackStoreBindingAdapter adapter = new DefaultBackStoreBindingAdapter(this);
        this._isUpdateBoundData = true;
        this.bind(adapter, false);
    }

    @Override
    public void bind(IBindingAdapter adapter, boolean recurse) {
        if (adapter == this._adapter) {
            return;
        }
        if (recurse) {
            for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
                if (!this.eIsSet(feature)) continue;
                Object featureValue = this.eGet(feature);
                adapter.setFeature(feature, featureValue);
            }
        }
        if (this._isBound) {
            BoundEObjectImpl.disposeAdapter(this, this._adapter, false);
            this._isBound = false;
        }
        this._adapter = adapter;
        this._recurse = recurse;
        this.eAdapters().add((Object)adapter);
        this._isBound = true;
    }

    @Override
    public void unbind() {
        boolean recurse;
        boolean bl = recurse = this._recurse || this.eInternalContainer() == null;
        if (this._isBound) {
            BoundEObjectImpl.disposeAdapter(this, this._adapter, recurse);
        }
        this._adapter = null;
        this._isBound = false;
    }

    @Override
    public boolean isBound() {
        return this._isBound;
    }

    private static void disposeAdapter(EObject boundObject, IBindingAdapter adapter, boolean recurse) {
        boundObject.eAdapters().remove((Object)adapter);
        adapter.dispose(recurse);
    }

    @Override
    public boolean getUpdateBoundData() {
        return this._isUpdateBoundData;
    }

    @Override
    public void setUpdateBoundData(boolean update) {
        this._isUpdateBoundData = update;
    }

    @Override
    public String getInvalidRawValue(int featureId) {
        return null;
    }

    @Override
    public boolean isSetInvalid(int featureId) {
        return false;
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(this.getClass());
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof IDOMElement) {
            IDOMElement domElement = (IDOMElement)notifier;
            switch (eventType) {
                case 2: {
                    if (!(newValue instanceof Text)) break;
                    this.handleAdd(domElement, (Text)newValue);
                    break;
                }
                case 3: {
                    if (!(oldValue instanceof Text)) break;
                    this.handleRemove(domElement, (Text)oldValue);
                    break;
                }
                case 5: {
                    if (!(changedFeature instanceof Text) || !(newValue instanceof String)) break;
                    this.handleContentChanged(domElement, (String)newValue);
                    break;
                }
                case 1: {
                    if (!(changedFeature instanceof IDOMAttr)) break;
                    IDOMAttr attribute = (IDOMAttr)changedFeature;
                    this.handleChange(oldValue, newValue, attribute, domElement);
                }
            }
        }
    }

    private void handleContentChanged(IDOMElement domElement, String newValue) {
        EClass eClass;
        String elementName = domElement.getLocalName();
        String uri = ((INodeBindingAdapter)this._adapter).getNamespaceContext().getNamespace((Node)domElement);
        if (elementName != null && uri != null && (eClass = this.getEClass(elementName, uri)) != null) {
            EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getTextContentFeature(eClass);
            this.fireSetEvent(null, newValue, eClass, feature);
        }
    }

    private void handleRemove(IDOMElement domElement, Text oldValue) {
        EClass eClass;
        String elementName = domElement.getLocalName();
        String uri = ((INodeBindingAdapter)this._adapter).getNamespaceContext().getNamespace((Node)domElement);
        if (elementName != null && uri != null && (eClass = this.getEClass(elementName, uri)) != null) {
            EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getTextContentFeature(eClass);
            this.fireSetEvent(oldValue.getNodeValue(), null, eClass, feature);
        }
    }

    private void handleAdd(IDOMElement domElement, Text newValue) {
        EClass eClass;
        String elementName = domElement.getLocalName();
        String uri = ((INodeBindingAdapter)this._adapter).getNamespaceContext().getNamespace((Node)domElement);
        if (elementName != null && uri != null && (eClass = this.getEClass(elementName, uri)) != null) {
            EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getTextContentFeature(eClass);
            this.fireSetEvent(null, newValue.getNodeValue(), eClass, feature);
        }
    }

    private void handleChange(Object oldValue, Object newValue, IDOMAttr attribute, IDOMElement domElement) {
        String elementName = domElement.getLocalName();
        String uri = ((INodeBindingAdapter)this._adapter).getNamespaceContext().getNamespace((Node)domElement);
        if (elementName != null && uri != null) {
            EClass eClass = this.getEClass(elementName, uri);
            EStructuralFeature feature = ExtendedMetaData.INSTANCE.getAttribute(eClass, null, attribute.getLocalName());
            this.fireSetEvent(oldValue, newValue, eClass, feature);
        }
    }

    private EClass getEClass(String elementName, String uri) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
        String findName = ExtendedEcoreUtil.INSTANCE.getAnnotationName(elementName);
        EClass eClass = (EClass)ExtendedMetaData.INSTANCE.getType(ePackage, findName);
        return eClass;
    }

    private void fireSetEvent(Object oldValue, Object newValue, EClass eClass, EStructuralFeature feature) {
        if (eClass != null && feature != null) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, this.eClass().getFeatureID(feature), oldValue, newValue));
        }
    }

    @Override
    public IBindingAdapter getBindingAdapter() {
        return this._adapter;
    }
}

