/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;

public class BindingUtil {
    public static boolean isNumericAttribute(AttributeDefinition attrDef) {
        String javaType;
        return attrDef != null && (BindingUtil.isNumberType(javaType = attrDef.getJavaTypeString()) || JavaUtil.isPrimitiveNumeric((String)javaType) || "java.lang.Byte".equals(javaType) || "java.lang.Short".equals(javaType));
    }

    public static boolean isNumberType(String javaType) {
        return "java.lang.Number".equals(javaType) || "java.lang.Integer".equals(javaType) || "java.lang.Long".equals(javaType) || "java.lang.Float".equals(javaType) || "java.lang.Double".equals(javaType) || "java.math.BigInteger".equals(javaType) || "java.math.BigDecimal".equals(javaType) || "oracle.jbo.domain.Number".equals(javaType) || "oracle.jbo.domain.DBSequence".equals(javaType);
    }

    public static boolean isDateAttribute(AttributeDefinition attrDef) {
        return attrDef != null && BindingUtil.isDateType(attrDef.getJavaTypeString());
    }

    public static boolean isDateType(String javaType) {
        return "oracle.jbo.domain.Date".equals(javaType) || "java.util.Date".equals(javaType) || "oracle.jbo.domain.Timestamp".equals(javaType) || "oracle.jbo.domain.TimestampTZ".equals(javaType) || "oracle.jbo.domain.TimestampLTZ".equals(javaType) || "java.sql.Timestamp".equals(javaType) || "java.sql.Date".equals(javaType);
    }

    public static boolean isAccessorDefinition(NamedDefinition namedDef) {
        AccessorDefinition accessorDef;
        int defType;
        return namedDef != null && (100 == (defType = namedDef.getDefinitionType()) && namedDef instanceof AccessorDefinition || 40 == defType) && ADFBindingUtils.hasAttributeDefinitions((Definition)(accessorDef = (AccessorDefinition)namedDef)) && !ADFBindingUtils.isAccessorChildOfConstructorNode((AccessorDefinition)accessorDef) && accessorDef.isCollection();
    }

    public static List<AttributeDefinition> getAttributeDefinitions(StructureDefinition structureDef, boolean sort) {
        DefinitionContainer sdAttrs;
        if (structureDef != null && (sdAttrs = structureDef.getAttributeDefinitions()) != null && !sdAttrs.isEmpty()) {
            Iterator iAttrs = sdAttrs.iterator();
            ArrayList<AttributeDefinition> arAttrDefs = new ArrayList<AttributeDefinition>();
            while (iAttrs.hasNext()) {
                AttributeDefinition attrDef = (AttributeDefinition)iAttrs.next();
                Object displayValue = attrDef.getProperty("DISPLAYHINT");
                if (displayValue != null && "Hide".equals(displayValue)) continue;
                arAttrDefs.add(attrDef);
            }
            if (sort) {
                Collections.sort(arAttrDefs, new AlphabeticAttributeComparator());
            }
            return arAttrDefs;
        }
        return null;
    }

    private static class AlphabeticAttributeComparator
    implements Comparator<AttributeDefinition> {
        private AlphabeticAttributeComparator() {
        }

        @Override
        public int compare(AttributeDefinition attr1, AttributeDefinition attr2) {
            String name1 = attr1.getName();
            String name2 = attr2.getName();
            if (name1 != null && name2 != null) {
                return name1.compareTo(name2);
            }
            if (name1 != null && name2 == null) {
                return -1;
            }
            if (name1 == null && name2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

